<div id="product-<?php the_ID(); ?>" <?php wc_product_class('product-page-mode3-style', $product); ?>>
    <div class="single-product-top-wrap">
        <div class="row">
            <div class="col-12 col-md-6 col-lg-4">
                <div class="product-single-inner-box">
                    <div class="product-sharing-box">
                        <svg width="18" height="18" viewBox="0 0 18 18" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M4.07672 11.2886C5.08737 11.2886 5.98856 11.7702 6.56503 12.5145L11.3921 9.81825C11.279 9.49353 11.2169 9.14327 11.2169 8.78207C11.2169 8.41721 11.279 8.0706 11.3957 7.74223L6.57233 5.0496C5.99951 5.79755 5.09467 6.28281 4.08037 6.28281C2.35095 6.28281 0.938965 4.87447 0.938965 3.1414C0.938965 1.40834 2.34731 0 4.08037 0C5.81343 0 7.22177 1.40834 7.22177 3.1414C7.22177 3.50626 7.15975 3.85652 7.04299 4.18124L11.8627 6.87387C12.4356 6.12227 13.3404 5.64066 14.3547 5.64066C16.0841 5.64066 17.4961 7.049 17.4961 8.78207C17.4961 10.5151 16.0841 11.9235 14.351 11.9235C13.3367 11.9235 12.4319 11.4382 11.8554 10.6866L7.03205 13.3829C7.1488 13.7113 7.21447 14.0652 7.21447 14.43C7.21447 16.1594 5.80613 17.5714 4.07307 17.5714C2.34001 17.5714 0.931667 16.1631 0.931667 14.43C0.931667 12.697 2.34366 11.2886 4.07672 11.2886ZM4.07672 0.988758C2.88729 0.988758 1.92042 1.95562 1.92042 3.14505C1.92042 4.33448 2.88729 5.30135 4.07672 5.30135C5.26615 5.30135 6.23301 4.33448 6.23301 3.14505C6.23301 1.95562 5.2625 0.988758 4.07672 0.988758ZM14.351 10.9384C15.5405 10.9384 16.5073 9.97149 16.5073 8.78207C16.5073 7.59264 15.5405 6.62577 14.351 6.62577C13.1616 6.62577 12.1947 7.59264 12.1947 8.78207C12.1947 9.97149 13.1653 10.9384 14.351 10.9384ZM4.07672 16.5827C5.26615 16.5827 6.23301 15.6158 6.23301 14.4264C6.23301 13.2369 5.26615 12.2701 4.07672 12.2701C2.88729 12.2701 1.92042 13.2369 1.92042 14.4264C1.92042 15.6158 2.88729 16.5827 4.07672 16.5827Z" fill="#43454D"/> </svg>
                        <div class="product-page-share-btns">
                            <a href="https://telegram.me/share/url?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>" target="_blank"><i aria-hidden="true" class="fab fa-telegram-plane"></i></a>
                            <a href="https://api.whatsapp.com/send?text=<?php the_permalink(); ?>" target="_blank"><i aria-hidden="true" class="fab fa-whatsapp"></i></a>
                            <a href="https://facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>" target="_blank"><i aria-hidden="true" class="fab fa-facebook-f"></i></a>
                            <a href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>" target="_blank"><i aria-hidden="true" class="fab fa-twitter"></i></a>
                            <a href="https://linkedin.com/shareArticle?url=<?php the_permalink(); ?>&title=<?php the_title(); ?>" target="_blank"><i aria-hidden="true" class="fab fa-linkedin-in"></i></a>
                        </div>
                    </div>
                    <?php woocommerce_show_product_images(); ?>
                </div>
            </div>
            <div class="col-12 col-md-6 col-lg-<?php echo $product->is_in_stock() ? '4' : '8' ?>">
                <div class="product-single-inner-box">
                    <?php woocommerce_template_single_title(); ?>
                    <?php woocommerce_show_product_sale_flash(); ?>
                    <?php if($product->get_rating_count()): ?>
                    <div class="product-star-rate">
                        <?php echo wc_get_rating_html($product->get_average_rating(), $product->get_rating_count()); ?>
                        <span class="avg-rate"><?php echo $product->get_average_rating() ?></span>
                        <span class="buyers-point">
                            <?php echo sprintf(__('(%d Buyers Points)', 'ahura'), $product->get_review_count()) ?>
                        </span>
                    </div>
                    <?php endif; ?>
                    <hr>
                    <?php
                    remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash');
                    remove_action('woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20);
                    do_action('woocommerce_before_single_product_summary');
                    ?>
                    <?php if (!$product->is_in_stock()): ?>
                        <div class="product-availability">
                            <?php ahura\app\woocommerce::render_out_of_stock_product_template() ?>
                            <?php woocommerce_template_single_price(); ?>
                        </div>
                    <?php endif; ?>
                    <div class="product-features-list">
                        <div class="product-excerpt">
                            <?php woocommerce_template_single_excerpt() ?>
                        </div>
                        <?php
                        $product_attributes = $product->get_attributes();
                        if ($product_attributes):
                            $attr_count = 4;
                            $product_attributes_arr = array_slice($product_attributes, 0, $attr_count);
                            ?>
                            <h4><?php echo __('Product Attributes', 'ahura') ?></h4>
                            <ul>
                                <?php foreach ($product_attributes_arr as $product_attribute_key => $product_attribute): ?>
                                    <li class="woocommerce-product-attributes-item woocommerce-product-attributes-item--<?php echo esc_attr($product_attribute_key); ?> pb-1">
                                        <span class="woocommerce-product-attributes-item__label">
                                            <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M11.3118 6.92368C10.9162 8.90196 9.42458 10.7647 7.33156 11.1809C6.31077 11.3842 5.25186 11.2603 4.3056 10.8267C3.35935 10.3932 2.57399 9.67217 2.06136 8.76632C1.54873 7.86047 1.33496 6.81598 1.45048 5.78157C1.56601 4.74716 2.00494 3.77556 2.70478 3.00512C4.14021 1.42409 6.56399 0.988867 8.54227 1.78018" stroke="#43454D" stroke-opacity="0.5" stroke-width="1.18696" stroke-linecap="round" stroke-linejoin="round"/> <path d="M4.58594 6.13203L6.56421 8.11031L11.3121 2.9668" stroke="#43454D" stroke-opacity="0.5" stroke-width="1.18696" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                                            <?php echo wc_attribute_label(wp_kses_post($product_attribute['name'])) . ':'; ?>
                                        </span>
                                        <span class="woocommerce-product-attributes-item__value">
                                        <?php echo $product->get_attribute(wp_kses_post($product_attribute['name'])); ?>
                                        </span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                            <?php if (count($product_attributes) > $attr_count): ?>
                                <a href="#tab-title-additional_information" class="ah-view-more-attr" rel="nofollow noopener"><?php echo __('More Attributes', 'ahura') ?><i class="fas fa-arrow-down"></i></a>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <?php if ($product->get_sku()) : ?>
                        <span class="product-sku">
                            <span class="sku-title"><?php echo __('SKU value: ', 'ahura'); ?></span>
                            <span class="sku-value"><?php echo $product->get_sku(); ?></span>
                        </span>
                    <?php endif; ?>
                    <?php echo do_action( 'woocommerce_product_meta_end' ); ?>
                </div>
            </div>
            <?php if($product->is_in_stock()): ?>
                <div class="col-12 col-md-12 col-lg-4">
                    <div class="product-single-inner-box product-single-cart-details-box">
                        <?php
                        \ahura\app\woocommerce::reset_and_render_single_product_summary();
                        woocommerce_template_single_add_to_cart();
                        ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="single-product-upsell">
        <?php woocommerce_upsell_display(); ?>
    </div>
    <div class="single-product-bottom-wrap">
        <?php woocommerce_output_product_data_tabs(); ?>
    </div>
    <div class="single-product-related">
        <?php woocommerce_output_related_products(); ?>
    </div>
</div>