<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class('d-flex flex-column product-page-digital-style p-3', $product); ?>>
    <div class="product-page-summary-container">
        <?php woocommerce_template_single_title(); ?>
        <div class="d-flex product-page-content w-100">
            <div class="gallery-section">
                <?php do_action('woocommerce_before_single_product_summary'); ?>
                <?php if(\ahura\app\mw_options::get_digital_product_preview_btn()): ?>
                    <div class="preview-btn-area">
                        <a href="<?php echo get_post_meta( $product->get_id(), 'demo_url', true ) ? get_post_meta( $product->get_id(), 'demo_url', true ) : '#'; ?>" class="btn" role="button" target="_blank">
                            <?php echo get_theme_mod('product_preview_button_text') ? get_theme_mod('product_preview_button_text') : __('Product preview', 'ahura'); ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="product-meta-container">
                <div class="product-meta-area">
                    <div class="product-meta-stats">
                        <div class="total-sales">
                            <h2><?php echo get_post_meta( $product->get_id(), 'total_sales', true ) ? get_post_meta( $product->get_id(), 'total_sales', true ) : '0'; ?></h2>
                            <p><?php echo get_theme_mod('digital_total_sales_text') ? get_theme_mod('digital_total_sales_text') : __('sale' ,'ahura'); ?></p>
                        </div>
                        <div class="user-satisfaction">
                            <?php if ($product->get_rating_counts()) : ?>
                                <?php echo '<h2>' . (($product->get_average_rating() * 100) / 5) . '<span>%</span>' . '</h2>'; ?>
                            <?php else : ?>
                                <?php echo '<h2>0<span>%</span></h2>'; ?>
                            <?php endif; ?>
                            <p><?php echo get_theme_mod('digital_total_satisfaction_text') ? get_theme_mod('digital_total_satisfaction_text') : __('satisfaction' ,'ahura'); ?></p>
                        </div>
                    </div>
                    <?php if(\ahura\app\mw_options::get_digital_marketplace_metaboxes()): ?>
                        <?php
                        $checklist = \ahura\app\Post_Meta::get_product_checklist();
                        if (\ahura\app\Post_Meta::show_product_checklist() && !empty($checklist)):?>
                            <ul class="product-meta-checklist">
                                <?php foreach ($checklist as $key => $item): ?>
                                    <li class="ck-item ck-item-<?php echo $key ?>">
                                        <?php if(isset($item['icon']) && !empty($item['icon'])): ?>
                                            <i class="<?php echo $item['icon'] ?>"></i>
                                        <?php endif; ?>
                                        <span><?php echo $item['value'] ?></span>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php else: ?>
                            <?php if(get_post_meta($product->get_id(), 'checklist_item1', true)): ?>
                                <ul class="product-meta-checklist">
                                    <?php for ($index = 1; get_post_meta( $product->get_id(), 'checklist_item' . $index, true ); $index++): ?>
                                        <li><?php echo get_post_meta( $product->get_id(), 'checklist_item' . $index, true ); ?></li>
                                    <?php endfor; ?>
                                </ul>
                            <?php endif; ?>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php if(get_theme_mod('digital_product_checklist_text1') || get_theme_mod('digital_product_checklist_text2') || get_theme_mod('digital_product_checklist_text3') || get_theme_mod('digital_product_checklist_text4')): ?>
                            <ul class="product-meta-checklist">
                                <?php if(get_theme_mod('digital_product_checklist_text1')): ?>
                                    <li>
                                        <?php if(get_theme_mod('digital_checklist_items_icon')): ?>
                                            <i aria-hidden="true" class="<?php echo get_theme_mod('digital_checklist_items_icon') ?>"></i>
                                        <?php endif; ?>
                                        <span>
                                            <?php echo get_theme_mod('digital_product_checklist_text1'); ?>
                                        </span>
                                    </li>
                                <?php endif; ?>
                                <?php if(get_theme_mod('digital_product_checklist_text2')): ?>
                                    <li>
                                        <?php if(get_theme_mod('digital_checklist_items_icon')): ?>
                                            <i aria-hidden="true" class="<?php echo get_theme_mod('digital_checklist_items_icon') ?>"></i>
                                        <?php endif; ?>
                                        <span>
                                            <?php echo get_theme_mod('digital_product_checklist_text2'); ?>
                                        </span>
                                    </li>
                                <?php endif; ?>
                                <?php if(get_theme_mod('digital_product_checklist_text3')): ?>
                                    <li>
                                        <?php if(get_theme_mod('digital_checklist_items_icon')): ?>
                                            <i aria-hidden="true" class="<?php echo get_theme_mod('digital_checklist_items_icon') ?>"></i>
                                        <?php endif; ?>
                                        <span>
                                            <?php echo get_theme_mod('digital_product_checklist_text3'); ?>
                                        </span>
                                    </li>
                                <?php endif; ?>
                                <?php if(get_theme_mod('digital_product_checklist_text4')): ?>
                                    <li>
                                        <?php if(get_theme_mod('digital_checklist_items_icon')): ?>
                                            <i aria-hidden="true" class="<?php echo get_theme_mod('digital_checklist_items_icon') ?>"></i>
                                        <?php endif; ?>
                                        <span>
                                            <?php echo get_theme_mod('digital_product_checklist_text4'); ?>
                                        </span>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        <?php endif; ?>
                    <?php endif; ?>
                    <div class="product-excerpt">
                        <?php woocommerce_template_single_excerpt() ?>
                    </div>
                    <?php
                    \ahura\app\woocommerce::reset_and_render_single_product_summary();
                    woocommerce_template_single_add_to_cart();
                    ?>
                    <div class="product-cats">
                        <?php
                        $cats_list = wc_get_product_term_ids($product->get_id(), 'product_cat');
                        $cats_delimiter = is_rtl() ? '، ' : ', ';
                        $class_list = is_rtl() ? 'pl-1' : 'pr-1';
                        if($cats_list) echo '<span class=' . $class_list .'>' . __('Category:', 'ahura') . '</span>';
                        foreach ($cats_list as $index => $cat_id) {
                            if (count($cats_list) - 1 == $index) $cats_delimiter = '';
                            echo "<a href=" . get_category_link($cat_id) . " class='cat-name'>" . get_term_by('id', $cat_id, 'product_cat')->name . '</span><span class="cat-delimiter">' . $cats_delimiter . '</span></a>';
                        }
                        ?>
                    </div>
                    <?php echo do_action( 'woocommerce_product_meta_end' ); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="d-flex flex-column mb-3">
        <?php woocommerce_upsell_display(); ?>
    </div>
    <div class="d-flex flex-column mb-3">
        <?php woocommerce_output_product_data_tabs(); ?>
    </div>
    <div class="d-flex flex-column product-page-digital-related">
        <?php woocommerce_output_related_products(); ?>
    </div>
</div>