<!DOCTYPE html>
<html <?php language_attributes(); ?> class=" no-js">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <?php
    \ahura\app\mw_options::theme_viewport_meta_html();
    wp_head();
    ?>
</head>
<body <?php body_class('not-logged-in') ?>>
    <?php wp_body_open(); ?>
    <div class="site-container">
        <?php
        $logo = \ahura\app\mw_options::get_my_account_logo_url();
        $register = isset($_POST['register']);
        $has_registration = get_option('woocommerce_enable_myaccount_registration') == 'yes';
        ?>
        <div class="ah-my-account-login-page <?php echo $register ? 'has-register' : '' ?>">
            <?php if ($logo): ?>
            <div class="ah-account-logo">
                <a href="<?php echo esc_attr(site_url()) ?>">
                    <img src="<?php echo esc_attr($logo) ?>" alt="logo">
                </a>
            </div>
            <?php endif; ?>
            <div class="ah-my-account-form">
                <?php
                $is_lost_password = (isset($_GET['action']) && $_GET['action'] == 'lostpassword') || is_wc_endpoint_url('lost-password');

                if($is_lost_password){
                    require_once locate_template('woocommerce/myaccount/form-lost-password.php');
                }  else {
                    require_once locate_template('woocommerce/myaccount/form-login.php');
                }
                ?>
                <?php if($has_registration && !$is_lost_password): ?>
                    <div class="register-link-wrap">
                        <a href="#" rel="nofollow noopener" class="ah-toggle-account-register-form" style="display:<?php echo $register ? 'none' : '' ?>">
                            <?php _e('Don`t have an account? Sign up', 'ahura') ?>
                        </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="ah-account-foot">
                <a href="<?php echo esc_attr(site_url()) ?>"><?php _e('Back to home', 'ahura') ?></a>
            </div>
        </div>
    </div>
</body>
</html>