<?php
$posts = get_posts(['post_type' => 'post', 'post_status' => 'publish', 'numberposts' => 6]);
?>
<div class="account-latest-post-list">
    <?php if ($posts): ?>
        <div class="row">
            <?php foreach ($posts as $post): ?>
                <div class="col-12 col-sm-6 col-md-4">
                    <div class="post-item">
                        <a href="<?php echo get_the_permalink($post->ID) ?>">
                            <div class="post-cover">
                                <?php
                                if(has_post_thumbnail($post->ID)){
                                    echo get_the_post_thumbnail($post->ID);
                                } else {
                                    ahura_placeholder_image();
                                }
                                ?>
                            </div>
                            <h2 class="post-title"><?php echo $post->post_title ?></h2>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="account-notice"><?php _e('No article has been published yet.', 'ahura') ?></div>
    <?php endif; ?>
</div>