<?php

$wp_button_class = isset($wp_button_class) && !empty($wp_button_class) ? $wp_button_class : '';

$customer_orders = wc_get_orders(
    apply_filters(
        'woocommerce_my_account_my_orders_query',
        array(
            'customer' => get_current_user_id(),
            'numberposts' => 5,
        )
    )
);

if ( $customer_orders ) : ?>
    <table class="woocommerce-orders-table woocommerce-MyAccount-orders shop_table shop_table_responsive my_account_orders account-orders-table">
        <tbody>
        <?php
        foreach ( $customer_orders as $customer_order ) :
            $order = wc_get_order( $customer_order ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
            $item_count = $order->get_item_count() - $order->get_item_count_refunded();
            ?>
            <tr class="woocommerce-orders-table__row woocommerce-orders-table__row--status-<?php echo esc_attr( $order->get_status() ); ?> order">
                <?php foreach ( wc_get_account_orders_columns() as $column_id => $column_name ) :
                    $is_order_number = 'order-number' === $column_id;
                    ?>
                    <?php if ( $is_order_number ) : ?>
                    <th class="woocommerce-orders-table__cell woocommerce-orders-table__cell-<?php echo esc_attr( $column_id ); ?>" data-title="<?php echo esc_attr( $column_name ); ?>" scope="row">
                    <?php else : ?>
                    <td class="woocommerce-orders-table__cell woocommerce-orders-table__cell-<?php echo esc_attr( $column_id ); ?>" data-title="<?php echo esc_attr( $column_name ); ?>">
                    <?php endif; ?>

                    <?php if ( has_action( 'woocommerce_my_account_my_orders_column_' . $column_id ) ) : ?>
                    <?php do_action( 'woocommerce_my_account_my_orders_column_' . $column_id, $order ); ?>

                    <?php elseif ( $is_order_number ) : ?>
                        <?php /* translators: %s: the order number, usually accompanied by a leading # */ ?>
                        <a href="<?php echo esc_url( $order->get_view_order_url() ); ?>" aria-label="<?php echo esc_attr( sprintf( __( 'View order number %s', 'woocommerce' ), $order->get_order_number() ) ); ?>">
                            <?php echo esc_html( _x( '#', 'hash before order number', 'woocommerce' ) . $order->get_order_number() ); ?>
                        </a>

                    <?php elseif ( 'order-date' === $column_id ) : ?>
                        <time datetime="<?php echo esc_attr( $order->get_date_created()->date( 'c' ) ); ?>"><?php echo esc_html( wc_format_datetime( $order->get_date_created() ) ); ?></time>

                    <?php elseif ( 'order-status' === $column_id ) : ?>
                        <?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?>

                    <?php elseif ( 'order-total' === $column_id ) : ?>
                        <?php
                        /* translators: 1: formatted order total 2: total order items */
                        echo wp_kses_post( sprintf( _n( '%1$s for %2$s item', '%1$s for %2$s items', $item_count, 'woocommerce' ), $order->get_formatted_order_total(), $item_count ) );
                        ?>

                    <?php elseif ( 'order-actions' === $column_id ) : ?>
                        <?php
                        $actions = wc_get_account_orders_actions( $order );

                        if ( ! empty( $actions ) ) {
                            foreach ( $actions as $key => $action ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
                                /* translators: %s: order number */
                                echo '<a href="' . esc_url( $action['url'] ) . '" class="woocommerce-button' . esc_attr( $wp_button_class ) . ' button ' . sanitize_html_class( $key ) . '" aria-label="' . esc_attr( sprintf( __( 'View order number %s', 'woocommerce' ), $order->get_order_number() ) ) . '">' . esc_html( $action['name'] ) . '</a>';
                            }
                        }
                        ?>
                    <?php endif; ?>

                    <?php if ( $is_order_number ) : ?>
                    </th>
                    <?php else : ?>
                    </td>
                    <?php endif; ?>
                <?php endforeach; ?>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php else: ?>
    <div class="account-notice"><?php _e('You have not placed an order so far.', 'ahura') ?></div>
<?php endif; ?>