<?php
global $product;
$attachment_ids = $product->get_gallery_image_ids();

if ($attachment_ids && count($attachment_ids) > 0) : ?>
    <div class="swiper thumbnail-swiper">
        <div class="swiper-wrapper">
            <?php echo '<div class="swiper-slide">' . woocommerce_get_product_thumbnail() . '</div>';
            
            foreach ($attachment_ids as $attachment_id) {
                $image_url = wp_get_attachment_image($attachment_id, 'woocommerce_thumbnail');
                echo '<div class="swiper-slide">' . $image_url . '</div>';
            }
            ?>
        </div>
        <div class="swiper-pagination-wrapper">
            <div class="swiper-pagination"></div>
        </div>
    </div>
<?php else :
    add_action("woocommerce_before_shop_loop_item_title", "woocommerce_template_loop_product_thumbnail");
endif;
