<?php
$show_thumb = has_post_thumbnail() && (get_theme_mod('show_single_post_thumbnail') != 'none' && get_post_meta(get_the_ID(), 'hide_thumbnail', true) !== 'no');
?>
<div class="wrapper single-post-template-3">
    <section class="post-box content">
        <?php
        if (isset($right_sidebar) && $right_sidebar){
            $sidebar->col($right_sidebar)->display();
        }
        ?>
        <div class="theiaStickySidebar">
            <?php
            if (\ahura\app\mw_options::page_has_breadcsrumb()) {
                include get_template_directory() . '/template-parts/single/bread-crumb2.php';
            }
            ?>
            <article class="post-entry post-entry-custom post-custom">
                <div class="post-title-wrap">
                    <?php if (\ahura\app\mw_options::get_mod_show_single_post_title()): ?>
                        <header class="post-title">
                            <h1><?php the_title(); ?></h1>
                        </header>
                    <?php endif; ?>
                </div>
                <div class="post-meta-wrap">
                    <?php if (\ahura\app\mw_options::get_mod_show_content_types()): ?>
                        <div class="post-types-list">
                            <?php ahura_html_content_types(get_the_ID()); ?>
                        </div>
                    <?php endif; ?>
                    <ul class="post-meta">
                        <?php if (get_theme_mod('single_post_meta_time')) : ?>
                            <li class="post-date">
                                <svg width="26" height="30" viewBox="0 0 26 30" fill="none" xmlns="http://www.w3.org/2000/svg"> <path opacity="0.4" d="M1.12305 11.5392H24.8883" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.4" d="M18.9237 16.7462H18.9361M13.0071 16.7462H13.0194M7.07812 16.7462H7.09048M18.9237 21.9283H18.9361M13.0071 21.9283H13.0194M7.07812 21.9283H7.09048" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M18.3926 1.66666V6.05436" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M7.62109 1.66666V6.05436" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M18.651 3.77225H7.36128C3.4457 3.77225 1 5.95349 1 9.96295V22.0291C1 26.1016 3.4457 28.3333 7.36128 28.3333H18.6387C22.5666 28.3333 25 26.1395 25 22.13V9.96295C25.0123 5.95349 22.579 3.77225 18.651 3.77225Z" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                                <?php echo get_the_date('d F Y'); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('show_author', true)) : ?>
                            <li class="post-author-name">
                                <svg width="22" height="28" viewBox="0 0 22 28" fill="none" xmlns="http://www.w3.org/2000/svg"> <path fill-rule="evenodd" clip-rule="evenodd" d="M10.9806 18.4614C5.82373 18.4614 1.41992 19.2411 1.41992 22.3636C1.41992 25.4862 5.79579 26.2938 10.9806 26.2938C16.1374 26.2938 20.5399 25.5128 20.5399 22.3916C20.5399 19.2703 16.1653 18.4614 10.9806 18.4614Z" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.4" fill-rule="evenodd" clip-rule="evenodd" d="M10.9799 14.0077C14.364 14.0077 17.1069 11.2636 17.1069 7.87943C17.1069 4.4953 14.364 1.75244 10.9799 1.75244C7.59576 1.75244 4.8516 4.4953 4.8516 7.87943C4.84021 11.2521 7.56528 13.9963 10.9367 14.0077H10.9799Z" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                                <?php the_author(); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('show_categories', true)) : ?>
                            <li class="post-cats">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M21.67 14.3L21.27 19.3C21.12 20.83 21 22 18.29 22H5.71001C3.00001 22 2.88001 20.83 2.73001 19.3L2.33001 14.3C2.25001 13.47 2.51001 12.7 2.98001 12.11C2.99001 12.1 2.99001 12.1 3.00001 12.09C3.55001 11.42 4.38001 11 5.31001 11H18.69C19.62 11 20.44 11.42 20.98 12.07C20.99 12.08 21 12.09 21 12.1C21.49 12.69 21.76 13.46 21.67 14.3Z" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10"/> <path d="M3.5 11.43V6.28003C3.5 2.88003 4.35 2.03003 7.75 2.03003H9.02C10.29 2.03003 10.58 2.41003 11.06 3.05003L12.33 4.75003C12.65 5.17003 12.84 5.43003 13.69 5.43003H16.24C19.64 5.43003 20.49 6.28003 20.49 9.68003V11.47" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M9.42993 17H14.5699" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                                <?php the_category(', '); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('post-meta-comments') && get_comments_number()): ?>
                            <li class="post-comment-count">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M17.98 10.79V14.79C17.98 15.05 17.97 15.3 17.94 15.54C17.71 18.24 16.12 19.58 13.19 19.58H12.79C12.54 19.58 12.3 19.7 12.15 19.9L10.95 21.5C10.42 22.21 9.56 22.21 9.03 21.5L7.82999 19.9C7.69999 19.73 7.41 19.58 7.19 19.58H6.79001C3.60001 19.58 2 18.79 2 14.79V10.79C2 7.86001 3.35001 6.27001 6.04001 6.04001C6.28001 6.01001 6.53001 6 6.79001 6H13.19C16.38 6 17.98 7.60001 17.98 10.79Z" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M21.98 6.79001V10.79C21.98 13.73 20.63 15.31 17.94 15.54C17.97 15.3 17.98 15.05 17.98 14.79V10.79C17.98 7.60001 16.38 6 13.19 6H6.79004C6.53004 6 6.28004 6.01001 6.04004 6.04001C6.27004 3.35001 7.86004 2 10.79 2H17.19C20.38 2 21.98 3.60001 21.98 6.79001Z" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M13.4955 13.25H13.5045" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M9.9955 13.25H10.0045" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M6.4955 13.25H6.5045" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                                <?php printf(_nx('One Comment', '%1$s Comments', get_comments_number(), 'comments title', 'ahura'), number_format_i18n(get_comments_number())); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('show_date')): ?>
                            <li class="post-date">
                                <svg width="26" height="30" viewBox="0 0 26 30" fill="none" xmlns="http://www.w3.org/2000/svg"> <path opacity="0.4" d="M1.12305 11.5392H24.8883" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path opacity="0.4" d="M18.9237 16.7462H18.9361M13.0071 16.7462H13.0194M7.07812 16.7462H7.09048M18.9237 21.9283H18.9361M13.0071 21.9283H13.0194M7.07812 21.9283H7.09048" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M18.3926 1.66666V6.05436" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M7.62109 1.66666V6.05436" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path fill-rule="evenodd" clip-rule="evenodd" d="M18.651 3.77225H7.36128C3.4457 3.77225 1 5.95349 1 9.96295V22.0291C1 26.1016 3.4457 28.3333 7.36128 28.3333H18.6387C22.5666 28.3333 25 26.1395 25 22.13V9.96295C25.0123 5.95349 22.579 3.77225 18.651 3.77225Z" stroke="#333333" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                                <?php echo get_the_date('Y/m/d'); ?>
                            </li>
                        <?php endif; ?>

                        <?php if (get_theme_mod('show_update_date')) : ?>
                            <li class="post-modified-date">
                                <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M8 2V5" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M16 2V5" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M3.5 9.08997H20.5" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M19.21 15.77L15.6701 19.31C15.5301 19.45 15.4 19.71 15.37 19.9L15.18 21.25C15.11 21.74 15.45 22.0801 15.94 22.0101L17.29 21.82C17.48 21.79 17.75 21.66 17.88 21.52L21.4201 17.9801C22.0301 17.3701 22.3201 16.6601 21.4201 15.7601C20.5301 14.8701 19.82 15.16 19.21 15.77Z" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M18.7001 16.28C19.0001 17.36 19.8401 18.2 20.9201 18.5" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M12 22H8C4.5 22 3 20 3 17V8.5C3 5.5 4.5 3.5 8 3.5H16C19.5 3.5 21 5.5 21 8.5V12" stroke="#292D32" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"/> <path d="M11.9955 13.7H12.0045" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M8.29431 13.7H8.30329" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> <path d="M8.29431 16.7H8.30329" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/> </svg>
                                <?php if (get_theme_mod('post_update_date_text')): ?>
                                    <span class="pl-1"><?php echo get_theme_mod('post_update_date_text'); ?><?php echo the_modified_time('j F Y'); ?></span>
                                <?php else: ?>
                                    <?php the_modified_time('j F Y'); ?>
                                <?php endif; ?>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="row post-content-row">
                    <?php if (has_excerpt()): ?>
                        <div class="col-12 <?php echo sprintf('col-md-%1$s col-lg-%1$s', ($show_thumb ? '6' : '12')) ?>">
                            <div class="post-excerpt"><?php the_excerpt() ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if ($show_thumb): ?>
                        <div class="col-12 <?php echo sprintf('col-md-%1$s col-lg-%1$s', (has_excerpt() ? '6' : '12')) ?>">
                            <div class="post-thumbnail-wrap">
                                <div class="single-post-thumbnail"><?php the_post_thumbnail('full'); ?></div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="post-content-wrap">
                    <?php if (!dynamic_sidebar('ahura_start_content_widget')) : ?>
                    <?php endif; ?>
                    <?php
                    the_content();
                    ?>
                    <?php if (!dynamic_sidebar('ahura_content_widget')) : ?>
                    <?php endif; ?>
                </div>
                <?php
                ahura_single_post_like_template(get_the_ID());

                if (\ahura\app\mw_options::get_mod_show_post_sharing()):
                    include_once ahura_get_full_path('template-parts.single', 'share-buttons-2.php');
                endif;
                ?>
                <?php if (get_theme_mod('show_star_rating')): ?>
                    <div class="post-rating-wrap">
                        <div class="box-title"><?php _e('Was this post helpful to you?', 'ahura') ?></div>
                        <?php
                        if (empty(get_post_meta(get_the_id(), '_post_star_meta', true))):
                            $post_rating = 5;
                        else:
                            $post_rating = get_post_meta(get_the_id(), '_post_star_meta', true);
                        endif;
                        $args = array(
                            'rating' => $post_rating,
                            'type' => 'rating',
                            'number' => 1270,
                        );
                        require_once(ABSPATH . 'wp-admin/includes/template.php');
                        wp_star_rating($args);
                        ?>
                    </div>
                <?php endif; ?>
                <?php if (\ahura\app\mw_options::get_mod_show_post_author()): ?>
                    <div class="post-author-wrap">
                        <div class="author-avatar-wrap"><?php echo get_avatar(get_the_author_meta('email'), '125'); ?></div>
                        <div class="author-des-wrap">
                            <?php $author_url = get_the_author_meta('url'); ?>
                            <span class="author-name">
                            <?php
                            the_author();
                            if ($author_url): ?>
                                <a target="_blank" rel="nofollow" href="<?php echo $author_url; ?>">
                                    <i class="fas fa-globe"></i>
                                    <?php echo __('Website', 'ahura'); ?>
                                </a>
                            <?php endif; ?>
                        </span>
                            <div class="author-text">
                                <?php the_author_meta('description'); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </article>
            <?php
            if (\ahura\app\mw_options::get_mod_show_related_posts()):
                do_action('ah_render_single_related_posts_template');
            endif;
            ?>
            <div class="post-entry ah-post-comments-wrap single-post-comments-wrap ah-simple-box-style">
                <?php comments_template(); ?>
            </div>
            <?php if (\ahura\app\mw_options::get_mod_show_post_tags() && has_tag()): ?>
                <div class="post-tags-wrap">
                    <div class="box-title"><?php _e('Tags', 'ahura') ?></div>
                    <div id="post-tags">
                        <?php the_tags('', '', ''); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
    <?php
    if (isset($left_sidebar) && $left_sidebar){
        $sidebar->col($left_sidebar)->display();
    }
    ?>
</div>
<div class="clear"></div>
