<?php
global $post;
$mode = \ahura\app\mw_options::get_single_download_box_mode();
$status = \ahura\app\Post_Meta::is_active_download_box($post->ID);
$download_items = \ahura\app\Post_Meta::get_download_items($post->ID);
$files_password = \ahura\app\Post_Meta::get_files_password($post->ID);

if (!$status || empty($download_items))
    return false;

$password_html = sprintf('<div class="files-password-box"><span>%s</span><span>%s</span></div>', __('Files Password', 'ahura'), $files_password);
?>
<div class="ah-download-box-container ah-download-box-template-<?php echo $mode ?>">
    <?php if ($mode == 2): ?>
        <?php foreach ($download_items as $item): ?>
            <div class="ah-download-item">
                <span><?php echo $item['title'] ?></span>
                <a href="<?php echo $item['link'] ?>">
                    <?php echo __('Download', 'ahura') ?>
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M17.0523 0.333496C21.0073 0.333496 23.6673 3.11016 23.6673 7.2285V16.7602C23.6673 20.8902 21.0073 23.6668 17.0523 23.6668H6.93732C2.98348 23.6668 0.333984 20.8902 0.333984 16.7602V7.2285C0.333984 3.11016 2.98348 0.333496 6.93732 0.333496H17.0523ZM12.0007 6.36516C11.5107 6.36516 11.1257 6.75016 11.1257 7.24016V14.6485L8.24399 11.7552C8.08065 11.5918 7.84732 11.4985 7.62565 11.4985C7.40515 11.4985 7.18232 11.5918 7.00732 11.7552C6.66898 12.0935 6.66898 12.6535 7.00732 12.9918L11.3823 17.3902C11.709 17.7168 12.2923 17.7168 12.619 17.3902L16.994 12.9918C17.3323 12.6535 17.3323 12.0935 16.994 11.7552C16.644 11.4168 16.0957 11.4168 15.7457 11.7552L12.8757 14.6485V7.24016C12.8757 6.75016 12.479 6.36516 12.0007 6.36516Z" fill="white"/> </svg>
                </a>
            </div>
        <?php endforeach; ?>
        <?php
        if (!empty($files_password)){
            echo $password_html;
        }
        ?>
    <?php else: ?>
        <div class="ahura-download-box-wrap" id="ah-post-download-box">
            <div class="ahura-download-box">
                <div class="box-title">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M16.4405 8.8999C20.0405 9.2099 21.5105 11.0599 21.5105 15.1099V15.2399C21.5105 19.7099 19.7205 21.4999 15.2505 21.4999H8.74047C4.27047 21.4999 2.48047 19.7099 2.48047 15.2399V15.1099C2.48047 11.0899 3.93047 9.2399 7.47047 8.9099" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        <g opacity="0.4">
                            <path d="M12 2V14.88" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M15.3504 12.6504L12.0004 16.0004L8.65039 12.6504" stroke="#292D32" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                        </g>
                    </svg>
                    <span><?php _e('Download Links', 'ahura') ?></span>
                </div>
                <div class="download-items">
                    <?php foreach ($download_items as $item): ?>
                        <a href="<?php echo $item['link'] ?>" target="_blank" class="download-link"><?php echo $item['title'] ?></a>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php
            if (!empty($files_password)){
                echo $password_html;
            }
            ?>
        </div>
    <?php endif; ?>
</div>