<?php
$is_product_tab3 = false;
$is_product_tab3 = isset($carousel_type) && $carousel_type == 'product_tab3';
?>
<div class="<?php echo $is_product_tab3 ? 'w-100' : 'col-12 col-sm-12 col-md-4 col-lg-3'; ?>">
    <div <?php wc_product_class('product-item ah-has-bg', $product) ?>>
        <?php if(!$is_product_tab3): ?>
            <div class="pt-overly ah-has-bg">
                <div class="o-content">
                    <a href="<?php echo get_the_permalink() ?>">
                        <?php if(isset($settings['basket_icon'])): ?>
                            <?php \Elementor\Icons_Manager::render_icon( $settings['basket_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                        <?php endif; ?>
                        <div class="pt-o-title ah-has-text"><?php echo esc_html__('View Product', 'ahura'); ?></div>
                    </a>
                </div>
            </div>
        <?php endif; ?>
        <div class="product-details<?php echo $is_product_tab3 ? ' flex-column-reverse' : ''; ?>">
            <div class="pt-top<?php echo $is_product_tab3 ? ' pt-3' : ''; ?>">
                <div class="row p-0 m-0">
                    <div class="<?php echo $is_product_tab3 ? 'col-12' : 'col-10 p-0'; ?>">
                        <a href="<?php echo get_the_permalink() ?>">
                            <h2 class="product-title ah-has-text"><?php the_title(); ?></h2>
                        </a>
                    </div>
                    <?php if(isset($settings['share_icon']) && !$is_product_tab3): ?>
                        <div class="col-2 p-0">
                            <div class="float-buttons">
                                <div class="share-btns ah-has-text">
                                    <div class="share-btn">
                                        <?php \Elementor\Icons_Manager::render_icon( $settings['share_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                    <div class="btns">
                                        <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo get_the_permalink() ?>&source=<?php echo site_url() ?>" target="_blank"><i class="fab fa-linkedin-in"></i></a>
                                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo get_the_permalink() ?>" target="_blank"><i class="fab fa-facebook-f"></i></a>
                                        <a href="https://twitter.com/intent/tweet?text=<?php echo get_the_permalink() ?>" target="_blank"><i class="fab fa-twitter"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="<?php echo $is_product_tab3 ? 'col-12 d-flex align-items-center justify-content-between' : 'col-10 p-0'; ?>">
                        <div class="price-wrap ah-has-text <?php echo isset($item['item_dis_price_show']) && $item['item_dis_price_show'] != 'yes' ? 'del-dis-price' : '' ?>">
                            <?php woocommerce_template_single_price(); ?>
                        </div>
                        <?php if($is_product_tab3 && (isset($settings['show_product_button']) && $settings['show_product_button'] == 'yes')): ?>
                            <div class="product-button d-flex justify-content-center align-items-center">
                                <a href="<?php echo get_the_permalink() ?>" role="button">
                                    <?php \Elementor\Icons_Manager::render_icon( $settings['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php if(!$is_product_tab3): ?>
                        <div class="col-2 p-0">
                            <div class="float-buttons">
                                <?php if (in_array('yith-woocommerce-wishlist/init.php', apply_filters('active_plugins', get_option('active_plugins')))): ?>
                                    <div class="fav-btns"><?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="pt-bottom">
                <div class="product-cover">
                <?php if($is_product_tab3 && (isset($settings['show_variation_colors']) && $settings['show_variation_colors'] == 'yes') && $product->is_type('variable')): ?>
                    <?php Global $wpdb;
                        $variation_list_colors = [];
                        $variations = $product->get_available_variations();
                        foreach ($variations as $variation) {
                            foreach (wc_get_product($variation['variation_id'])->get_variation_attributes() as $attribute_name => $attribute_value) {
                                $term_id = $wpdb->get_var($wpdb->prepare("SELECT term_id FROM $wpdb->terms WHERE slug = %s", $attribute_value));
                                $term_meta_value = get_term_meta($term_id, '_product_attribute_color', true);
                                if ($term_meta_value) {
                                    array_push($variation_list_colors, $term_meta_value);
                                }
                            }
                        }
                        if($variation_list_colors): ?>
                            <ul class="color-variations-list">
                                <?php foreach($variation_list_colors as $color_hex): ?>
                                    <li style="background-color:<?php echo $color_hex; ?>;"></li>
                                <?php endforeach; ?>
                            </ul>
                        <?php endif; ?>
                    <?php endif; ?>
                    <a href="<?php echo get_the_permalink() ?>">
                        <?php echo wp_get_attachment_image(get_post_thumbnail_id(), isset($settings['item_cover_size']) ? $settings['item_cover_size'] : 'full') ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>