<?php 
$show_mode_switcher = \ahura\app\mw_options::get_mod_show_theme_mode_switcher();

$ahura_is_on_mobile = (function_exists('ahura_detect_user_device')) && ahura_detect_user_device() !== 'Desktop';

if (\ahura\app\mw_options::get_mod_is_active_dark_theme() && $show_mode_switcher):
    $mode_switcher_titles = \ahura\app\mw_options::get_mod_show_theme_mode_switcher_titles();
    $mode_switcher_dropdown = \ahura\app\mw_options::get_mod_show_theme_mode_dropdown();
    $switcher_alignment = \ahura\app\mw_options::get_header_style() == 1 ? 'justify-content-end' : 'justify-content-center';
    $show_mode = \ahura\app\mw_options::get_mod_theme_switcher_display_mode();
?>
<div class="d-flex align-items-center theme-mode-switcher-container show-mode-<?php echo $show_mode ?> <?php echo $switcher_alignment; ?>">
    <?php if($mode_switcher_dropdown): ?>
        <div class="theme-mode-switcher option-select-theme-switcher hide-in-sticky">
            <select id="theme-mode-dropdown"<?php echo $ahura_is_on_mobile ? ' class="is-mobile"' : ''; ?>>
                <option value="ahura-light-theme" <?php echo ahura_get_current_theme_mode(true, 'light') ? 'selected' : '' ?>>
                    <?php echo $ahura_is_on_mobile ? '&#9728;' : '&#xf185;'; ?>
                </option>
                <option value="ahura-dark-theme" <?php echo ahura_get_current_theme_mode(true, 'dark') ? 'selected' : '' ?>>
                    <?php echo $ahura_is_on_mobile ? '&#9790;' : '&#xf186;'; ?>
                </option>
                <option value="ahura-black-theme" <?php echo ahura_get_current_theme_mode(true, 'black') ? 'selected' : '' ?>>
                    <?php echo $ahura_is_on_mobile ? '&#9733;' : '&#xf005;'; ?>
                </option>
            </select>
        </div>
    <?php endif; ?>
    <div class="theme-mode-switcher hide-in-sticky <?php echo !$mode_switcher_titles ? 'without-titles' : '' ?>"<?php echo $mode_switcher_dropdown ? ' style="visibility:hidden;opacity:0;width:0%"' : ''; ?>>
        <input type="radio" id="ahura-light-theme" data-mode="ahura-light-theme" name="theme-mode-switch" <?php echo ahura_get_current_theme_mode(true, 'light') ? 'checked' : '' ?>/>
        <label for="ahura-light-theme">
            <span>
                <i class="fa fa-sun"></i>
                <?php if ($mode_switcher_titles): ?>
                    <em><?php echo esc_html__('Light', 'ahura'); ?></em>
                <?php endif; ?>
            </span>
        </label>
        <input type="radio" id="ahura-dark-theme" data-mode="ahura-dark-theme" name="theme-mode-switch" <?php echo ahura_get_current_theme_mode(true, 'dark') ? 'checked' : '' ?>/>
        <label for="ahura-dark-theme">
            <span>
                <i class="fa fa-moon"></i>
                <?php if ($mode_switcher_titles): ?>
                    <em><?php echo esc_html__('Dark', 'ahura'); ?></em>
                <?php endif; ?>
            </span>
        </label>
        <input type="radio" id="ahura-black-theme" data-mode="ahura-black-theme" name="theme-mode-switch" <?php echo ahura_get_current_theme_mode(true, 'black') ? 'checked' : '' ?>/>
        <label for="ahura-black-theme">
            <span>
                <i class="fa fa-star"></i>
                <?php if ($mode_switcher_titles): ?>
                    <em><?php echo esc_html__('Black', 'ahura'); ?></em>
                <?php endif; ?>
            </span>
        </label>
        <span class="slider"></span>
    </div>
</div>
<?php
endif;