<section class="site-container page-404">
    <div class="template-404 template-404-2">
        <div class="temp-details">
            <?php if(get_theme_mod('ahura_404_show_text',true)):?>
                <h3>
                    <span><?php _e('I`m sorry', 'ahura') ?></span>
                    <?php _e('No content found to display.', 'ahura') ?>
                </h3>
            <?php endif;?>
            <p><?php _e('Content may not already exist or may have been removed.', 'ahura') ?></p>
            <p><?php _e('However, you can search with another keyword.', 'ahura') ?></p>
            <div class="search-temp">
                <form action="<?php echo site_url() ?>" method="get" role="search">
                    <input type="text" name="s" placeholder="<?php _e('what are you looking for', 'ahura') ?>" value="<?php echo (isset($_GET['s'])) ? esc_attr($_GET['s']) : '' ?>">
                    <select name="post_type">
                        <?php
                        $post_types = [
                            'post' => __('Posts', 'ahura'),
                        ];
                        if (ahura\app\woocommerce::is_active()){
                            $post_types['product'] = __('Products', 'ahura');
                        }

                        $current_post_type = isset($_GET['post_type']) && !empty($_GET['post_type']) ? esc_attr($_GET['post_type']) : null;
                        foreach ($post_types as $post_type => $label):
                        ?>
                            <option <?php selected($current_post_type, $post_type) ?> value="<?php echo esc_attr($post_type) ?>"><?php echo $label ?></option>
                        <?php endforeach; ?>
                    </select>
                    <button type="submit"><?php _e('Search', 'ahura') ?></button>
                </form>
            </div>
            <?php if(get_theme_mod('ahura_404_show_go_home') && !is_front_page()):?>
                <a href="<?php echo get_theme_mod('ahura_404_go_home_url') ? get_theme_mod('ahura_404_go_home_url') : site_url();?>">
                    <svg xmlns="http://www.w3.org/2000/svg" class="icon icon-tabler icon-tabler-home" width="20px" height="20px" viewBox="0 0 24 24" stroke-width="1.5" stroke="#000000" fill="none" stroke-linecap="round" stroke-linejoin="round"> <path stroke="none" d="M0 0h24v24H0z" fill="none"/> <path d="M5 12l-2 0l9 -9l9 9l-2 0" /> <path d="M5 12v7a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-7" /> <path d="M9 21v-6a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v6" /> </svg>
                    <?php echo get_theme_mod('ahura_404_go_home_text', __('Return to home'));?>
                </a>
            <?php endif;?>
        </div>
        <?php if(get_theme_mod('ahura_404_show_image',true)):?>
            <div class="temp-cover">
                <?php if(get_theme_mod('ahura_404_show_image',true)):?>
                    <img src="<?php echo get_theme_mod('ahura_404_image') ? get_theme_mod('ahura_404_image') : get_template_directory_uri() . '/img/404.webp'?>" alt="404">
                <?php endif;?>
            </div>
        <?php endif;?>
    </div>
</section>