<?php
use ahura\app\license;
use ahura\app\Ahura_Alert;

$demo_base_url = \ahura\app\Studio::get_base_url();
$license_status = license::is_active();
$has_error = !$license_status;
?>
<div class="wrap">
    <div class="studio-content">
        <?php if (!$has_error): ?>
            <?php if($license_status): ?>
            <div class="ahura-filter-tabs">
                <div class="filters-top">
                    <div class="search-wrap">
                        <input type="text" placeholder="<?php _e('Search...', 'ahura') ?>">
                    </div>
                    <div class="filter-tabs-list"></div>
                </div>
                <div class="filters-bottom">
                    <div class="buttons">
                        <form action="" method="post" class="<?php echo esc_attr( $multi_import ); ?>">
                            <footer class="merlin__content__footer">
                                <a id="close" href="<?php echo esc_url( $this->step_next_link() ); ?>" class="merlin__button merlin__button--skip merlin__button--closer merlin__button--proceed"><?php echo esc_html( $skip ); ?></a>
                                <a id="skip" href="#" data-href="<?php echo esc_url( $this->step_next_link() ); ?>" class="merlin__button merlin__button--skip merlin__button--proceed"><?php echo esc_html( $skip ); ?></a>
                            </footer>
                        </form>
                        <a href="<?php echo admin_url() ?>" class="back-to-admin"><?php echo __('Return to the dashboard', 'ahura') ?></a>
                    </div>
                </div>
            </div>
            <?php if (!\ahura\app\mw_config::has_minimum_php_version()): ?>
                <div class="ah-notice ah-error">
                    <p><?php echo sprintf(__('The required PHP version of the theme is %s, please change the PHP version through the host to use the demo installer.', 'ahura'), \ahura\app\mw_config::MINIMUM_PHP_VER) ?></p>
                </div>
            <?php else: ?>
                <div class="ahura-filter-tab-items ahura-studio-filter-tab-items">
                    <a href="#" class="aside-btn"><?php _e('Categories', 'ahura') ?></a>
                   <div class="items-list"></div>
                </div>
            <?php endif; ?>
            <?php
            else:
                Ahura_Alert::adminNotice(esc_html__('Please active ahura theme license.', 'ahura'), Ahura_Alert::WARNING);
            endif;
            ?>
        <?php else: ?>
            <div class="studio-error">
                <div class="msg-content">
                    <span class="notice-icon dashicons dashicons-warning"></span>
                    <p class="notice-message">
                        <?php
                        if(!$license_status) {
                            echo esc_html__('This section is only available if the license is active', 'ahura');
                            echo "<br>";
                            echo esc_html__('First, activate the Ahura license', 'ahura');
                        } else {
                            echo esc_html__('An unknown error occurred.', 'ahura');
                        }
                        ?>
                        <?php if ($license_status): ?>
                            <br>
                            <span>(<?php echo esc_html__('Try again in a few minutes.', 'ahura'); ?>)</span>
                        <?php endif; ?>
                    </p>
                    <?php if(!$license_status): ?>
                        <a href="<?php echo admin_url('admin.php?page=ahura-wizard&step=license') ?>"><?php echo esc_html__('License activation', 'ahura') ?></a>
                    <?php else: ?>
                        <a href="<?php echo admin_url() ?>"><?php echo esc_html__('Back to dashboard', 'ahura') ?></a>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php if ($license_status): ?>
    <div class="studio-loader">
        <div class="loader-content">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 200"><circle fill="#6E4CF2" stroke="#6E4CF2" stroke-width="10" r="15" cx="40" cy="65"><animate attributeName="cy" calcMode="spline" dur="0.9" values="65;135;65;" keySplines=".5 0 .5 1;.5 0 .5 1" repeatCount="indefinite" begin="-.4"></animate></circle><circle fill="#6E4CF2" stroke="#6E4CF2" stroke-width="10" r="15" cx="100" cy="65"><animate attributeName="cy" calcMode="spline" dur="0.9" values="65;135;65;" keySplines=".5 0 .5 1;.5 0 .5 1" repeatCount="indefinite" begin="-.2"></animate></circle><circle fill="#6E4CF2" stroke="#6E4CF2" stroke-width="10" r="15" cx="160" cy="65"><animate attributeName="cy" calcMode="spline" dur="0.9" values="65;135;65;" keySplines=".5 0 .5 1;.5 0 .5 1" repeatCount="indefinite" begin="0"></animate></circle></svg>
            <p><?php echo __('Getting demo list...', 'ahura') ?></p>
            <a href="<?php echo admin_url() ?>"><?php echo __('Return to the dashboard', 'ahura') ?></a>
        </div>
    </div>
<?php endif; ?>