<?php
$dont_recreate_page = !\ahura\app\woocommerce::is_active() || wc_get_page_id('checkout') == -1 || !get_post_status(wc_get_page_id('checkout')) ? true : false;
do_action('ah_ahura_tools_page_requests', ['dont_recreate_page' => $dont_recreate_page]);
?>
<div class="ahura-tools-page-wrapper">
    <h2><?php _e('Tools Page', 'ahura') ?></h2>
    <form action="" method="post">
        <div class="control-group">
            <div class="control-header">
                <p class="control-title">
                    <?php echo __('Fix the Elementor editor not loading problem.', 'ahura'); ?>
                </p>
                <p class="ahura-tools-hint">
                    <?php if (!is_active_elementor()) : ?>
                        <?php echo __('Notice: Elementor page builder plugin not installed or activated', 'ahura'); ?>
                    <?php endif; ?>
                </p>
            </div>
            <button type="submit" name="submitToolsOption" value="flush_permalink" <?php if (!is_active_elementor()) echo 'class="disabled"'; ?>><?php echo __('Start Fixing', 'ahura'); ?></button>

            <?php if (is_active_elementor()): ?>
                <?php if (!ahura_is_optimized_permalink()): ?>
                    <div class="ah-important-notice">
                        <p><?php _e('Note that if this operation is performed, changes will be made in the structure of permalinks and all links (articles, etc.) will become SEO friendly.', 'ahura') ?></p>
                    </div>
                <?php else: ?>
                    <div class="ah-important-notice success">
                        <p><?php _e('Permalinks to your website are optimal, you can do this in any case.', 'ahura') ?></p>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
        <div class="control-group">
            <div class="control-header">
                <p class="control-title">
                    <?php echo __('Rebuild current checkout page to default woocommerce checkout page.', 'ahura'); ?>
                </p>
                <p class="ahura-tools-hint">
                    <?php if (!\ahura\app\woocommerce::is_active()) : ?>
                        <?php echo __('Notice: Woocommerce plugin not installed or activated.', 'ahura'); ?>
                    <?php elseif (FALSE == get_post_status(wc_get_page_id('checkout')) || wc_get_page_id('checkout') == -1) : ?>
                        <?php echo __('Notice: There is not any active checkout page or not assigned to as checkout page in Woocommerce settings page.', 'ahura'); ?>
                    <?php endif; ?>
                </p>
            </div>
            <button type="submit" name="submitToolsOption" value="recreate_checkout_page" <?php if ($dont_recreate_page) echo 'class="disabled"'; ?>>
                <?php echo __('Rebuild', 'ahura'); ?>
            </button>
        </div>
    </form>
    <?php \ahura\app\Ahura_Alert::showMessage(true); ?>
</div>