const ahuraHandleRelatedProductsSlider = function (params){
    if(jQuery(document).find('.product-related-slider').length){
        jQuery('.product-related-slider .products').owlCarousel({
            loop:false,
            margin:10,
            responsiveClass:true,
            autoplay:true,
            autoplayTimeout:4000,
            rtl: document.body.classList.contains('rtl') ? true : false,
            navText: [
                '<i class="fas fa-angle-left"></i>',
                '<i class="fas fa-angle-right"></i>'
            ],
            responsive:{
                0:{
                    items: params.mobileItems,
                    nav: params.showNav
                },
                600:{
                    items: params.mobileItems,
                    nav: params.showNav
                },
                1000:{
                    items: params.desktopItems,
                    nav: params.showNav,
                    loop: false
                }
            }
        })
    }
}

const ahuraHandleSaleShopSlider = function (params){
    if(jQuery(document).find('.shop-best-sale-slider').length){
        jQuery('.shop-best-sale-slider .products').owlCarousel({
            loop:false,
            margin:10,
            responsiveClass:true,
            autoplay:false,
            rtl: document.body.classList.contains('rtl') ? true : false,
            navText: [
                '<i class="fas fa-angle-left"></i>',
                '<i class="fas fa-angle-right"></i>'
            ],
            responsive:{
                0:{
                    items: params.mobileItems,
                    nav: true
                },
                600:{
                    items: params.mobileItems,
                    nav: true
                },
                1000:{
                    items: params.desktopItems,
                    nav: true,
                    loop: false
                }
            }
        })
    }
}

jQuery(document).ready(function($){
    var mw_qty_mode = {};
    mw_qty_mode.increase = function(mw_qty_input)
    {
        let cu_value = mw_qty_input.val(),
            new_value = parseInt(cu_value) + 1;
        mw_qty_input.val(new_value);
    }
    mw_qty_mode.decrease = function(mw_qty_input)
    {
        let cu_value = mw_qty_input.val(),
            new_value = parseInt(cu_value) - 1;
        if(new_value <= 0)
        {
            return false;
        }
        mw_qty_input.val(new_value);
    }
    function mw_change_qty(mw_qty_input, mode)
    {
        let cu_value = parseInt(mw_qty_input.val()),
            new_value = '';
        switch(mode)
        {
            case 'increase':
                new_value = cu_value + 1;
                break;
            case 'decrease':
                new_value = (cu_value <= 1) ? 1 : cu_value - 1;
                break;
        }

        mw_qty_input.val(new_value);
        mw_qty_input.trigger('change');
    }
    $(document).on('click', '.mw_qty_btn', function (e) {
        e.preventDefault();
        let mw_this = $(this),
            mw_qty_input = mw_this.parent().find('input[type=number].qty'),
            mw_mode = mw_this.data('mw_qty_mode');
        mw_change_qty(mw_qty_input, mw_mode);
    });

    $(document).on('change', '.quantity .qty', function (e) {
        let $this = $(this),
            minVal = $this.attr('min'),
            maxVal = $this.attr('max'),
            incBtn = $this.parent().find('.mw_increasr'),
            decBtn = $this.parent().find('.mw_decrease'),
            isSingle = (parseInt(minVal) == 1 && parseInt(maxVal) == 1);
            inputVal = $this.val();
        if(inputVal <= 0 || isSingle){
            $this.val(1);
            if(isSingle){
                incBtn.addClass('disabled');
                decBtn.addClass('disabled');
                return false;
            } else {
                incBtn.removeClass('disabled');
                decBtn.removeClass('disabled');
            }
        } else {
            $this.val(parseInt($this.val()));
        }
        if(inputVal <= 1){
            decBtn.addClass('disabled');
        } else {
            decBtn.removeClass('disabled');
        }
        if(maxVal !== undefined && parseInt(maxVal) > 0){
            if(inputVal == parseInt(maxVal) || inputVal > parseInt(maxVal)){
                $this.val(parseInt(maxVal));
                incBtn.addClass('disabled');
            } else {
                incBtn.removeClass('disabled');
            }
        }
    });

    /**
     * 
     * 
     * Product single custom gallery zoom efect
     * 
     * 
     */
    function ahuraWooDataZoom() {
        $('.product-gallery-slider .woocommerce-product-gallery__image').on('mouseenter mouseleave',function () {
            $(this).attr('data-scale', '1.7');
            var img = $(this).find('img').attr('src');
            $(this).attr('data-image', img);
        });
    }

    function ahuraWooZoomFunction() {
        $('.product-gallery-slider .woocommerce-product-gallery__image')
            .on('mouseover', function () {
                $(this).children('.zoom-photo').css({ 'transform': 'scale(' + $(this).attr('data-scale') + ')' });
            })
            .on('mouseout', function () {
                $(this).children('.zoom-photo').css({ 'transform': 'scale(1)' });
            })
            .on('mousemove', function (e) {
                $(this).children('.zoom-photo').css({ 'transform-origin': ((e.pageX - $(this).offset().left) / $(this).width()) * 100 + '% ' + ((e.pageY - $(this).offset().top) / $(this).height()) * 100 + '%' });
            })
            .each(function () {
                var photoLength = $(this).find('.zoom-photo').length;
                if (photoLength === 0) {
                    $(this)
                        .append('<div class="zoom-photo"></div>')
                        .children('.zoom-photo').css({ 'background-image': 'url(' + $(this).find('img').attr('src') + ')' });
                }
            });
    }

    function ahuraWooZoomEffect() {
        $(document).on('click', '.product-gallery-slider .woocommerce-product-gallery__image', function () {
            ahuraWooZoomFunction();
        });
        $(".product-gallery-slider .woocommerce-product-gallery__image").on({
            mouseenter: function () {
                ahuraWooZoomFunction();
            },
            mouseleave: function () {
                ahuraWooZoomFunction();
            }
        });
    }

    ahuraWooDataZoom();
    ahuraWooZoomEffect();

    let more_seller_products = $('#tab-more_seller_product > .product');
    if(more_seller_products.length){
        more_seller_products.parent().addClass('is-direct-products');
    }

    $(document).on('click', '.ah-single-sticky-cart-variables-toggle-btn', function (e){
        e.preventDefault();
        let btn = $(this),
            variationsWrap = btn.parent().find('.variations');
        variationsWrap.slideToggle();
    });

    let stickyAddToCartWrap = $('.ahura-sticky-basket-area');
    if (stickyAddToCartWrap.length){
        $(window).scroll(function() {
            if (window.innerWidth > 767){
                stickyAddToCartWrap.removeClass('show-cart-button');
                return false;
            }

            if ($(window).scrollTop() >= $('.ahura_woocommerce_content_wrapper .single_add_to_cart_button').offset().top) {
                stickyAddToCartWrap.addClass('show-cart-button');
            } else {
                stickyAddToCartWrap.removeClass('show-cart-button');
            }
        });
    }

    $(document).on('click', '.comments-template-1 .comment-rate-buttons a', function (e){
        e.preventDefault()
        let btn = $(this),
            wrap = btn.parent();

        wrap.find('.selected').removeClass('selected');
        wrap.find('a .fas').removeClass('fas').addClass('far');
        btn.find('.far').removeClass('far').addClass('fas');
        btn.addClass('selected');

        $('.ah-comment-form-rating select').val(btn.data('star'));
    });

    $(document).on('input', '.comment-rate-list input', function (e){
        e.preventDefault();
    });

    $(document).on('click', '.comments-template-1 .comment-rate-list .ah-add-item', function (e){
        e.preventDefault()
        let btn = $(this),
            wrap = btn.parent().parent(),
            input = btn.parent().find('input'),
            inputVal = input.val();

        if (!inputVal){
            input.focus();
            return false;
        }

        input.val('');

        wrap.append(
            $('<div/>', {class: 'new-rate-item'}).append(
                $('<span/>', {text: inputVal}),
                $('<button/>', {type: 'button', class: 'remove-item'}).append(
                    $('<i/>', {class: 'fas fa-trash'})
                ),
                $('<input/>', {type: 'hidden', name: `${input.attr('data-name')}[]`, value: inputVal})
            )
        );
    });

    $(document).on('click', '.comments-template-1 .comment-rate-list .remove-item', function (e){
        $(this).parent().slideUp(function (){
            $(this).remove();
        });
    });

    if (typeof $.fn.theiaStickySidebar !== "undefined"){
        $('.comments-template-1 .product-comments-wrap, .comments-template-1 .product-comments-rate').theiaStickySidebar({
            additionalMarginTop: 30
        });
    }

    handleShopSubCategoriesCarousel();
});


let toggleAttributesBtn = document.querySelector('#more-attributes-toggle');
if(toggleAttributesBtn){
    toggleAttributesBtn.addEventListener('click', () => {
        if(document.querySelector('#more-attributes-toggle').checked ) {
            document.querySelector('.shop_attributes label.less').style.display = 'block';
            document.querySelector('.shop_attributes label.more').style.display = 'none';
        } else {
            document.querySelector('.shop_attributes label.less').style.display = 'none';
            document.querySelector('.shop_attributes label.more').style.display = 'block';
        }
    });
}


if (document.querySelector('.product-page-digi-tabs .tabs a')) {
    document.querySelectorAll('.product-page-digi-tabs .tabs a').forEach( item => {
        item.addEventListener('click', e => {
            document.querySelector('.product-page-digi-tabs .tabs a.active').classList.remove('active');
            item.classList.add('active');
        });
    });
    window.addEventListener('scroll', e => {
        document.querySelectorAll('.product-page-digi-tabs .wc-tab').forEach( value => {
            let item = value;
            if (window.scrollY >= item.offsetTop) {
                document.querySelector('.product-page-digi-tabs .tabs a.active').classList.remove('active');
                let id = item.getAttribute('id');
                document.querySelectorAll('.product-page-digi-tabs .tabs a').forEach( navItem => {
                    if (navItem.getAttribute('href') === '#' + id) navItem.classList.add('active');
                });
            }
        });
    });
}

const handleShopSubCategoriesCarousel = function (){
    if (typeof window.Swiper != undefined && document.querySelector('.shop-sub-categories')) {
        let isWide = document.querySelector('.ahura-1c-column');
        let options = {
            slidesPerView: 2,
            spaceBetween: 10,
            breakpoints: {
                640: {
                    slidesPerView: 2,
                },
                768: {
                    slidesPerView: (isWide ? 5 : 4),
                },
                1024: {
                    slidesPerView: (isWide ? 7 : 5),
                },
            },
        };

        new Swiper(`.shop-sub-categories .product-cats`, options);
    }
}

if (document.querySelector('.sale_price_date.special')) {

    const monthElement = document.querySelector('.sale_price_date.special .mn .v');
    const dayElement = document.querySelector('.sale_price_date.special .d');
    const hourElement = document.querySelector('.sale_price_date.special .h');
    const minuteElement = document.querySelector('.sale_price_date.special .m');

    let months = monthElement ? parseInt(monthElement.textContent.match(/(\d+)/)[1]) || 0 : 0;
    let days = dayElement ? parseInt(dayElement.textContent.match(/(\d+)/)[1]) || 0 : 0;
    let hours = hourElement ? parseInt(hourElement.textContent.match(/(\d+)/)[1]) || 0 : 0;
    let minutes = minuteElement ? parseInt(minuteElement.textContent.match(/(\d+)/)[1]) || 0 : 0;

    let totalTimeMs = (months * 30 * 24 * 60 * 60 * 1000) + (days * 24 * 60 * 60 * 1000) + (hours * 60 * 60 * 1000) + (minutes * 60 * 1000);

    function updateCountdown() {
        totalTimeMs -= 1000;

        let remainingMonths = Math.floor(totalTimeMs / (30 * 24 * 60 * 60 * 1000));
        let remainingDays = Math.floor((totalTimeMs % (30 * 24 * 60 * 60 * 1000)) / (24 * 60 * 60 * 1000));
        let remainingHours = Math.floor((totalTimeMs % (24 * 60 * 60 * 1000)) / (60 * 60 * 1000));
        let remainingMinutes = Math.floor((totalTimeMs % (60 * 60 * 1000)) / (60 * 1000));
        let remainingSeconds = Math.floor((totalTimeMs % (60 * 1000)) / 1000);

        if (monthElement) monthElement.textContent = `${remainingMonths} : `;
        if (dayElement) dayElement.textContent = `${remainingDays} : `;
        if (hourElement) hourElement.textContent = `${remainingHours} : `;
        if (minuteElement) minuteElement.textContent = `${remainingMinutes} : ${remainingSeconds}`;

        if (totalTimeMs > 0) setTimeout(updateCountdown, 1000);
    }

    updateCountdown();
}

jQuery(document).ready(function ($) {
    $('.woocommerce-archive-shop-sale-countdown').each(function () {
        let saleEndTime = $(this).data('sale-end') * 1000;
        let countdownElement = $(this).find('.countdown-timer');

        function updateCountdown() {
            let now = new Date().getTime();
            let timeRemaining = saleEndTime - now;

            if (timeRemaining > 0) {
                let days = Math.floor(timeRemaining / (1000 * 60 * 60 * 24));
                let hours = Math.floor((timeRemaining % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                let minutes = Math.floor((timeRemaining % (1000 * 60 * 60)) / (1000 * 60));
                let seconds = Math.floor((timeRemaining % (1000 * 60)) / 1000);

                days = days < 10 ? "0" + days : days;
                hours = hours < 10 ? "0" + hours : hours;
                minutes = minutes < 10 ? "0" + minutes : minutes;
                seconds = seconds < 10 ? "0" + seconds : seconds;

                countdownElement.text(days + ":" + hours + ":" + minutes + ":" + seconds);
            }
        }

        updateCountdown();
        setInterval(updateCountdown, 1000);
    });
});

if (typeof window.Swiper != undefined && document.querySelector('.woocommerce.archive .thumbnail-swiper')) {

    let options = {
        slidesPerView: 1,
        spaceBetween: 10,
        breakpoints: {
            640: {
                slidesPerView: 1,
            },
            768: {
                slidesPerView: 1,
            },
            1024: {
                slidesPerView: 1,
            },
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },
    };

    const swiperInstance = new Swiper(`.woocommerce.archive .thumbnail-swiper`, options);

    document.querySelectorAll('.swiper-pagination .swiper-pagination-bullet').forEach(bullet => {
        bullet.addEventListener('mouseenter', function() {
            this.click();
        });
    });
}
