jQuery(document).ready(function ($) {
    $('.product-gallery-slider').each(function(index, element) {
        let $gallerySlider = $(this);
        let $thumbsSlider = $gallerySlider.siblings('.product-gallery-thumbs-slider');
        let is_vertical = $thumbsSlider.data('slider') === 'vertical';

        let thumbsSliderOptions = {
            loop: false,
            slidesPerView: 3,
            spaceBetween: 7,
            navigation: {
                nextEl: $gallerySlider.parent().find(".swiper-button-next"),
                prevEl: $gallerySlider.parent().find(".swiper-button-prev"),
            },
        };

        if (is_vertical) {
            thumbsSliderOptions.direction = 'vertical';
        }

        let product_single_thumbs_slider = new Swiper($thumbsSlider[0], thumbsSliderOptions);

        let product_single_slider = new Swiper($gallerySlider[0], {
            loop: false,
            slidesPerView: 1,
            thumbs: {
                swiper: product_single_thumbs_slider,
            },
            navigation: {
                nextEl: $gallerySlider.parent().find(".swiper-button-next"),
                prevEl: $gallerySlider.parent().find(".swiper-button-prev"),
            },
        });
    });
});
