const handleVideoCarousel4Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: params.mobilePerView,
            spaceBetween: 20,
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView,
                    spaceBetween: 10,
                },
                768: {
                    slidesPerView: params.tabletPerView,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: params.slidesPerView,
                    spaceBetween: 20,
                },
            },
        };

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            }
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/video_carousel4.default', function($scope, $) {
        let wrap = $scope.find('.video-carousel4-wrap'),
            slider = wrap.find('.carousel-wrap'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleVideoCarousel4Element(sliderData);
    });
});