const handleVideoCarousel3Element = function (params){
    if (typeof window.Swiper != undefined){
        let sliderOptions = {
            loop: true,
            slidesPerView: 1,
            spaceBetween: 10,
            centeredSlides: true,
            pagination: {
                el: ".swiper-pagination",
            },
            navigation: {
                nextEl: ".swiper-button-next",
                prevEl: ".swiper-button-prev",
            },
        };

        if (params.autoplay == true){
            sliderOptions.autoplay = {
                delay: params.autoplayDelay,
                disableOnInteraction: true,
            };
        }

        if(params.observer === true){
            sliderOptions.observer = true;
            sliderOptions.observeParents = true;
        }

        let swiper = new Swiper(params.container, sliderOptions);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/video_carousel3.default', function($scope, $) {
        let wrap = $scope.find('.video-carousel3-wrap'),
            slider = wrap.find('.video-carousel3'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleVideoCarousel3Element(sliderData);
    });
});