const handleTimeline5Element = function (params){
    let options = {
        slidesPerView: params.mobilePerView,
        spaceBetween: 0,
        loop: false,
        breakpoints: {
            640: {
                slidesPerView: params.mobilePerView,
            },
            768: {
                slidesPerView: params.tabletPerView,
            },
            1024: {
                slidesPerView: params.desktopPerView,
            },
        },
    };

    if (params.autoPlay === true){
        options.autoplay = {
            delay: params.autoplayTimeout || 4500,
            disableOnInteraction: false,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/timeline5.default', function($scope, $) {
        let wrap = $scope.find('.timeline5-element'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleTimeline5Element(sliderData);
    });
});