const handleTestimonialCarousel8Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: 1,
            spaceBetween: 20,
        };

        if(params.showPagination){
            options.pagination = {
                el: '.swiper-pagination',
                clickable: true,
            }
        }

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            }
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/testimonial_carousel8.default', function($scope, $) {
        let wrap = $scope.find('.testimonial-carousel-8'),
            slider = wrap.find('.carousel-wrap'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleTestimonialCarousel8Element(sliderData);
    });
});