const handleTestimonialCarousel5Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: params.mobilePerView,
            spaceBetween: 20,
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView,
                    spaceBetween: 10,
                },
                768: {
                    slidesPerView: params.tabletPerView,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: params.slidesPerView,
                    spaceBetween: 20,
                },
            },
        };

        if(params.showPagination){
            options.pagination = {
                el: `.testimonial-carousel-5-${params.widgetID} .tc-swiper-pagination`,
                clickable: true,
            }

            if(params.paginationType !== 'default'){
                options.pagination.type = params.paginationType;
            }
        }

        if(params.navigation){
            options.navigation = {
                nextEl: `.testimonial-carousel-5-${params.widgetID} .tc-swiper-button-next`,
                prevEl: `.testimonial-carousel-5-${params.widgetID} .tc-swiper-button-prev`,
            }
        }

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            }
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let tc_swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/testimonial_carousel5.default', function($scope, $) {
        let wrap = $scope.find('.testimonial-carousel-5'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleTestimonialCarousel5Element(sliderData);
    });
});