const handleTestimonialCarousel12Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: 1,
            spaceBetween: 20,
        };

        options.pagination = {
            el: ".t-counter",
            type: "fraction",
        }

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            }
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/testimonial_carousel12.default', function($scope, $) {
        let wrap = $scope.find('.testimonial-carousel-12'),
            slider = wrap.find('.carousel-wrap'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleTestimonialCarousel12Element(sliderData);
    });
});