const handleTestimonialCarousel11Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: params.mobilePerView,
            centeredSlides: true,
            spaceBetween: 20,
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView,
                },
                768: {
                    slidesPerView: params.tabletPerView,
                },
                1024: {
                    slidesPerView: params.slidesPerView,
                },
            },
        };

        if(params.showPagination){
            options.pagination = {
                el: `.swiper-pagination`,
                clickable: true,
            }

            if(params.paginationType !== 'default'){
                options.pagination.type = params.paginationType;
            }
        }

        if(params.autoPlay){
            options.autoplay = {
                delay: params.delay,
                disableOnInteraction: false,
            }
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/testimonial_carousel11.default', function($scope, $) {
        let slider = $scope.find('.testimonial-carousel-items'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleTestimonialCarousel11Element(sliderData);
    });
});