const handleTestimonialCarousel10Element = function (params){
    if (typeof window.Swiper != undefined) {
        let setSlideHeight = function(that){
            params.container.find('.swiper-slide').css({height:'auto'});
            let currentSlide = that.activeIndex;
            let newHeight = jQuery(that.slides[currentSlide]).find('.testimonial-carousel-item-wrap').height();

            params.wrap.find('.swiper-wrapper,.swiper-slide').css({height:newHeight})
            that.update();
        }

        let options = {
            spaceBetween: 0,
            direction: "vertical",
            loop: params.loop || false,
            on:{
                init:function(){
                    setSlideHeight(this);
                },
                slideChangeTransitionEnd:function(){
                    setSlideHeight(this);
                }
            }
        };

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            }
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/testimonial_carousel10.default', function($scope, $) {
        let wrap = $scope.find('.testimonial-carousel-10'),
            slider = wrap.find('.slider-wrap'),
            sliderData = slider.data('slider');

        sliderData.wrap = wrap;
        sliderData.container = slider;

        handleTestimonialCarousel10Element(sliderData);
    });
});