const handleShopCategory4Element = function (params){
    let options = {
        slidesPerView: 2,
        spaceBetween: 0,
        freeMode: true,
        rtl: jQuery('body').hasClass('rtl'),
        breakpoints: {
            640: {
                slidesPerView: 3,
            },
            768: {
                slidesPerView: 5,
            },
            1024: {
                slidesPerView: 7,
            },
        },
    };

    if(params.navigation){
        options.navigation = {
            nextEl: ".swiper-btn-next",
            prevEl: ".swiper-btn-prev",
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_category4.default', function($scope, $) {
        let wrap = $scope.find('.shop-category4-wrap'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleShopCategory4Element(sliderData);
    });
});