const handleShopCategoryElement = function (params){
    let is_rtl = jQuery('body').hasClass('mw_rtl') ? true : false;
    params.container.owlCarousel({
        center: false,
        loop: false,
        items: 6,
        lazyLoad: true,
        rtl: is_rtl,
        margin: 25,
        navigation:true,
        navText : ["<i class='fa fa-3x fa-chevron-left'></i>","<i class='fa fa-3x fa-chevron-right'></i>"],
        responsive:{
            0:{
                items:1
            },
            400:{
                items:2
            },
            600:{
                items:2
            },
            860:{
                items:3
            },
            1000:{
                items:4
            }
        }
    });
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shopcategory.default', function($scope, $) {
        let wrap = $scope.find('.shop-category-element');

        handleShopCategoryElement({container: wrap.find('.owl-shop-category')});
    });
});