const handleShopCarousel8Element = function (params){
    let options = {
        spaceBetween: 10,
        rtl: jQuery('body').hasClass('mw_rtl'),
        breakpoints: {
            640: {
                slidesPerView: params.mobilePerView,
            },
            768: {
                slidesPerView: params.tabletPerView,
            },
            1024: {
                slidesPerView: params.desktopPerView,
            },
        },
    };

    if (params.pagination) {
        options.pagination = {
            el: `.swiper-shop-carousel8-${params.widgetID} .swiper-pagination`,
            clickable: true,
        };
    }

    if(params.arrows){
        options.navigation = {
            nextEl: '.swiper-btn-next',
            prevEl: '.swiper-btn-prev',
        }
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shopcarousel8.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel8-wrap'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleShopCarousel8Element(sliderData);
    });
});