const handleShopCarousel6Element = function (params){
    let options = {
        loop: params?.loop,
        autoplay: params?.autoplay,
        autoplayTimeout: params?.autoplayTimeout,
        slidesPerView: 1,
        spaceBetween: 10,
        freeMode: true,
        rtl: jQuery('body').hasClass('rtl'),
        breakpoints: {
            640: {
                slidesPerView: params.mobilePerView,
            },
            768: {
                slidesPerView: params.tabletPerView,
            },
            1024: {
                slidesPerView: params.desktopPerView,
            },
        },
    };

    if(params.arrows){
        options.navigation = {
            nextEl: ".swiper-btn-next",
            prevEl: ".swiper-btn-prev",
        };
    }

    if (params.pagination) {
        options.pagination = {
            el: `.shop-carousel6-wrap-${params.widgetID} .swiper-pagination`,
            clickable: true,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_carousel6.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel6-wrap'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleShopCarousel6Element(sliderData);
    });
});