const handleShopCarousel4Element = function (params){
    let options = {
        slidesPerView: 2,
        spaceBetween: params.spaceBetween,
        freeMode: true,
        rtl: jQuery('body').hasClass('mw_rtl'),
        breakpoints: {
            640: {
                slidesPerView: 2,
            },
            768: {
                slidesPerView: 4,
            },
            1024: {
                slidesPerView: 6,
            },
        },
    };

    if(params.navigation){
        options.navigation = {
            nextEl: ".swiper-btn-next",
            prevEl: ".swiper-btn-prev",
        }
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shopcarousel4.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel4-wrap'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleShopCarousel4Element(sliderData);
    });
});