const handleShopCarousel2Element = function (params){
    let is_rtl = jQuery('body').hasClass('mw_rtl') ? true : false;
    params.container.owlCarousel({
        loop: params.loop,
        autoplay: params.autoplay,
        autoplayTimeout: params.autoplayTimeout,
        center: false,
        items: 6,
        rtl: is_rtl,
        margin: 0,
        navigation:true,
        navText : ["<i class='fa fa-3x fa-chevron-left'></i>","<i class='fa fa-3x fa-chevron-right'></i>"],
        responsive:{
            0:{
                items:1
            },
            600:{
                items:3
            },
            1000:{
                items:4
            }
        }
    });
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_carousel2.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel2-element'),
            slider = wrap.find('.owl-shop-carousel2'),
            sliderData = slider.data('slider');

        handleShopCarousel2Element({
            container: slider,
            loop: sliderData.loop || true,
            autoplay: sliderData.autoplay || false,
            autoplayTimeout: sliderData.autoplayTimeout || 3000
        });
    });
});