const handleShopCarousel10Element = function (params){
    let wrap = params.wrap;
    let options = {
        loop: params.loop || false,
        on: {
            slideChange: function (){
                let activeSlide = this.slides[this.activeIndex],
                    productID = activeSlide.querySelector('.product-item').dataset.id,
                    activeBtn = wrap.find(`.slide-btn-${productID}`);

                wrap.find('.slider-pagination .slide-btn').removeClass('active');
                activeBtn.addClass('active');
            },
        }
    };

    if (params.autoPlay === true){
        options.autoplay = {
            delay: params.transitionDuration || 4500,
            disableOnInteraction: false,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);

    wrap.on('click', '.slide-btn', function (e){
        e.preventDefault();
        let activeIndex = this.dataset.index;

        swiper.slideTo(parseInt(activeIndex));
    });
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_carousel10.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel10-element'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.wrap = wrap;
        sliderData.container = slider;

        handleShopCarousel10Element(sliderData);
    });
});