const handlePostTab2Element = function (params) {
    let options = {
        loop: true,
        breakpoints: {
            640: {
                slidesPerView: 1,
            },
            768: {
                slidesPerView: 1,
            },
            1024: {
                slidesPerView: 1,
            },
        },
        on: {
            init: function () {
                let wrap = jQuery(this.$el);
                if(wrap){
                    wrap.addClass('swiper-initialized');
                }
            },
        },
    };

    if (params.autoPlayStatus === true) {
        options.autoplay = {
            delay: params.playDelay,
            disableOnInteraction: false,
        };
    }
    if (params.pagination) {
        options.pagination = {
            el: `.swiper-pagination`,
            clickable: true,
        };
    }

    if (params.arrows) {
        options.navigation = {
            nextEl: '.items-carousel-button-next',
            prevEl: '.items-carousel-button-prev',
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);
}
jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/post_tab2.default', function($scope, $) {
        let wrap = $scope.find('.post-tab2-wrap'),
            sliderData = wrap.data('slider');

        sliderData.container = wrap.find('.swiper-post-tab2');

        handlePostTab2Element(sliderData);
    });
});