jQuery(document).ready(function ($) {
    var body = $('body');

    body.on('click', '.post-tab .pt-item-btn', function (e) {
        e.preventDefault();
        let btn = $(this),
            gridWrap = $(`.post-tab-wrap-${btn.data('wid')}`),
            tabContentWrap = $(btn.data('tab')),
            tabItems = gridWrap.find('.pt-tab-items ul'),
            tabs = gridWrap.find('.pt-tab-content-wrap'),
            tabContent = tabContentWrap.find('.pt-tab-content'), appended, color;

        if (btn.parent().hasClass('active')) {
            return false;
        }

        if (tabContent.find('.post-item').length > 0 || tabContent.find('.mw_element_error').length > 0) {
            tabItems.find('.active').removeClass('active');
            btn.parent().addClass('active');
            tabs.removeClass('active').hide();
            tabContentWrap.addClass('active').show();
        } else {
            $.ajax({
                url: ahura_data.ajax_url,
                data: {
                    action: 'ahura_post_tab_ajax',
                    settings: btn.data('settings')
                },
                type: 'POST',
                dataType: 'html',
                success: function (res) {
                    tabContent.html(res);
                    tabItems.find('.active').removeClass('active');
                    btn.parent().addClass('active');
                    tabs.removeClass('active').hide();
                    tabContentWrap.addClass('active').show();
                },
                error: function () {
                    console.error('posts not found!');
                }
            });
        }
    });
});