jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_post_carousel_9.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel-9'),
            slider = wrap.find('.items-slider'),
            sliderData = slider.data('slider');

        let sliderOptions = {
            slidesPerView: sliderData.mobilePerView || 1,
            navigation: {
                nextEl: '.swiper-btn-next',
                prevEl: '.swiper-btn-prev',
            },
            spaceBetween: sliderData.margin || 25,
            breakpoints: {
                640: {
                    slidesPerView: sliderData.mobilePerView || 1,
                },
                768: {
                    slidesPerView: sliderData.tabletPerView || 3,
                },
                1024: {
                    slidesPerView: sliderData.perView || 4,
                },
            },
        };

        if (sliderData.autoplay === true){
            sliderOptions.autoplay = {
                delay: sliderData.delay || 4000,
                disableOnInteraction: false,
            };
        }

        if(sliderData.observer === true){
            sliderOptions.observer = true;
            sliderOptions.observeParents = true;
        }

        let swiper = new Swiper(slider, sliderOptions);
    });
});