const handlePostCarousel4Element = function (params){
    params.container.owlCarousel({
        center: true,
        loop: true,
        lazyLoad: true,
        items: params.sliderCount,
        autoplay: params.autoPlay,
        autoplaytimeout: 4000,
        margin: 30,
        navigation: true,
        navText: ["<i class='fa fa-3x fa-chevron-left'></i>", "<i class='fa fa-3x fa-chevron-right'></i>"],
        responsive: {
            0: {
                items: 1
            },
            400: {
                items: 1
            },
            600:{
                items: 2
            },
            1000: {
                items: params.sliderCount
            }
        }
    });
}
jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_post_carousel_4.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel-4'),
            data = wrap.data('json');

        data.container = wrap.find('.owl-post-carousel-4');

        handlePostCarousel4Element(data);
    });
});