const handlePostCarousel2Element = function (params){
    params.container.owlCarousel({
        center: true,
        loop: true,
        items: 4,
        lazyLoad: true,
        margin: 0,
        navigation: true,
        navText: ["<i class='fa fa-3x fa-chevron-left'></i>", "<i class='fa fa-3x fa-chevron-right'></i>"],
        responsive: {
            0: {
                items: 1
            },
            400: {
                items: 2
            },
            600: {
                items: 3
            },
            1000: {
                items: 4
            }
        }
    });
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/postcarousel2.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel2'),
            slider = wrap.find('.owl-post-carousel2'),
            sliderData = slider.data('slider');

        handlePostCarousel2Element({
            container: slider
        });
    });
});