const handlePostCarousel12Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: params.mobilePerView,
            spaceBetween: 20,
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView,
                    spaceBetween: 10,
                },
                768: {
                    slidesPerView: params.tabletPerView,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: params.slidesPerView,
                    spaceBetween: 20,
                },
            },
        };

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: true,
            };
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/post_carousel12.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel12'),
            slider = wrap.find('.posts-carousel'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handlePostCarousel12Element(sliderData);
    });
});