const handlePostCarousel10Element = function (params){
    if (typeof window.Swiper != undefined) {
        let sliderOptions = {
            watchSlidesProgress: true,
            slidesPerView: 1,
            loop: true,
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            navigation: {
                nextEl: '.swiper-btn-next',
                prevEl: '.swiper-btn-prev',
            },
            spaceBetween: 25,
            on: {
                init: function () {
                    jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).removeClass("animate");
                    jQuery(`.post-carousel-10-${params.widgetID} .slide_progress-bar span`).removeAttr("style");
                    jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).removeClass("active");
                    jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).eq(0).addClass("animate");
                    jQuery(`.post-carousel-10-${params.widgetID} .slide_progress-bar span`).css("transition-duration", params.delay + "ms");
                    jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).eq(0).addClass("active");
                },
                slideChangeTransitionStart: function () {
                    jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).removeClass("animate");
                    jQuery(`.post-carousel-10-${params.widgetID} .slide_progress-bar span`).removeAttr("style");
                    jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).removeClass("active");
                    jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).eq(0).addClass("active");
                },
                slideChangeTransitionEnd: function () {
                    jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).eq(0).addClass("animate");
                    jQuery(`.post-carousel-10-${params.widgetID} .slide_progress-bar span`).css("transition-duration", params.delay + "ms");

                }
            }
        };

        if (params.autoPlay) {
            sliderOptions.autoplay = {
                delay: params.delay || 4000,
                disableOnInteraction: false,
            };
        }

        if(params.observer === true){
            sliderOptions.observer = true;
            sliderOptions.observeParents = true;
        }

        let swiper = new Swiper(params.container, sliderOptions);

        if (params.autoPlay) {
            jQuery(`.post-carousel-10-${params.widgetID} .swiper-container`).hover(function () {
                swiper.autoplay.stop();
                jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).removeClass("animate");
                jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar span`).removeAttr("style");
            }, function () {
                swiper.autoplay.start();
                jQuery(`.post-carousel-10-${params.widgetID} .swiper-progress-bar`).addClass("animate");
                jQuery(`.post-carousel-10-${params.widgetID} .slide_progress-bar span`).css("transition-duration", params.delay + "ms");
            });
        }
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_post_carousel_10.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel-10'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handlePostCarousel10Element(sliderData);
    });
});