const handlePortfolio5Element = function (params){
  if (typeof window.Swiper != undefined) {
      let options = {
          loop: false,
          slidesPerView: params.mobilePerView,
          spaceBetween: 20,
          breakpoints: {
              640: {
                  slidesPerView: params.mobilePerView || 1,
                  spaceBetween: 10,
              },
              768: {
                  slidesPerView: params.tabletPerView || 3,
                  spaceBetween: 20,
              },
              1024: {
                  slidesPerView: params.slidesPerView || 4,
                  spaceBetween: 20,
              },
          },
      };

      if(params.autoPlay){
          options.autoplay = {
              delay: params.transitionDuration,
              disableOnInteraction: true,
          };
      }

      if(params.observer === true){
          options.observer = true;
          options.observeParents = true;
      }

      let swiper = new Swiper(params.container, options);
  }
}

jQuery(window).on('elementor/frontend/init', function (){
  elementorFrontend.hooks.addAction( 'frontend/element_ready/portfolio5.default', function($scope, $) {
      let wrap = $scope.find('.portfolio5-element'),
          slider = wrap.find('.posts-carousel'),
          sliderData = slider.data('slider');

      sliderData.container = slider;

      handlePortfolio5Element(sliderData);
  });
});

jQuery(document).ready(function ($) {
  $(document).on(
    "click",
    ".portfolio5-element .tabs-list .tab-item",
    function (e) {
      e.preventDefault();
      let button = $(this),
        wrap = button.closest(".portfolio5-element"),
        tabTarget = $(button.data("tab")),
        tabsContent = wrap.find(".tab-content-wrap");

      if (!tabTarget) return false;

      button.parent().find(".active").removeClass("active");
      button.addClass("active");

      tabsContent.hide().fadeOut(0);
      tabTarget.hide().fadeIn(200);
    }
  );
});