const handlePortfolio4Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: params.mobilePerView,
            spaceBetween: 30,
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView || 1,
                    spaceBetween: 0,
                },
                768: {
                    slidesPerView: params.tabletPerView || 3,
                    spaceBetween: 15,
                },
                1024: {
                    slidesPerView: params.desktopPerView || 4,
                    spaceBetween: 30,
                },
            },
        };

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            };
        }

        if(params.navigation){
            options.navigation = {
                nextEl: `.ahura-portfolio4-${params.widgetID} .swiper-btn-next`,
                prevEl: `.ahura-portfolio4-${params.widgetID} .swiper-btn-prev`,
            };
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let ahura_portfolio4 = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_portfolio4.default', function($scope, $) {
        let wrap = $scope.find('.ahura-portfolio4'),
            slider = wrap.find('.items-slider'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handlePortfolio4Element(sliderData);
    });
});