let selectors = document.querySelectorAll('.offer-carousel-1 .product-discount-timer-wrap');
if(selectors != null && selectors !== undefined){
    selectors.forEach((item) => {
        let datetime = item.dataset.time;
        if(datetime){
            ahuraDatetimeToCountdown(datetime, document.querySelector('.offer-carousel-1 .product-discount-timer-wrap-' + item.dataset.id));
        }
    });
}

const handleOfferCarouselElement = function (params){
    let lines = document.querySelectorAll(`.offer-carousel-${params.widgetID} .slider-duration-line`);

    let delay = params.autoPlayDelay || 4000;

    let initTransition = function (){
        params.container.find('.slider-duration-line').addClass('animate');
        params.container.find('.slider-duration-line').css("transition-duration", delay + "ms");
    }

    let options = {
        init: true,
        loop: true,
        slidesPerView: 1,
        spaceBetween: 5,
        mousewheel: false,
        allowTouchMove: false,
        followFinger: false,
        simulateTouch: false,
        preventInteractionOnTransition: true,
        keyboard: {
            enabled: false,
        },
        autoplay: {
            delay: delay,
            disableOnInteraction: false,
        },
        watchSlidesProgress: true,
        on: {
            init: function(){
                initTransition();
            },
            slideChangeTransitionEnd: function (){
                initTransition();
            },
            slideChangeTransitionStart: function (){
                params.container.find('.slider-duration-line').css("transition-duration", "0ms");
                params.container.find('.slider-duration-line').removeClass('animate');
            },
        }
    };

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/offer_carousel.default', function($scope, $) {
        let wrap = $scope.find('.ahura-offer-carousel'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleOfferCarouselElement(sliderData);
    });
});