const handleNewsTickerElement = function (params) {
    let options = {
        loop: true,
        slidesPerView: 1,
        spaceBetween: 60,
        navigation: {
            nextEl: '.items-swiper-button-next',
            prevEl: '.items-swiper-button-prev',
        },
        breakpoints: {
            640: {
                slidesPerView: 1,
                spaceBetween: 15,
            },
            768: {
                slidesPerView: 1,
                spaceBetween: 30,
            },
            1024: {
                slidesPerView: 1,
                spaceBetween: 60,
            },
        },
    };

    if (params.autoPlayStatus === true) {
        options.autoplay = {
            delay: params.playDelay,
            disableOnInteraction: false,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/news_ticker.default', function($scope, $) {
        let wrap = $scope.find('.news-ticker-wrapper'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleNewsTickerElement(sliderData);
    });
});