let handleNeshanMapElement = function(data){
    if (typeof L !== 'undefined') {
        const map = new L.Map('map_' + data.id, {
            key: data.api_key,
            maptype: data.style_mode !== 'custom' ? data.style_mode : data.style_key,
            poi: true,
            traffic: data.traffic_mode,
            center: [data.lat, data.lng],
            zoom: data.zoom
        });

        if (data.is_admin) {
            map.on("click", function (e) {
                if (typeof e.latlng !== undefined) {
                    let lnglat = e.latlng,
                        lng = lnglat.lng,
                        lat = lnglat.lat,
                        selector = jQuery('.neshan-map-1-' + data.id + ' .map-details .lnglat');
                    if (selector.length) {
                        if (lng && lat) {
                            selector.parent().css('display', 'block');
                            let text = data.text;
                            text = text.replace('{{LNG}}', lng);
                            text = text.replace('{{LAT}}', lat);
                            selector.text(text);
                        } else {
                            selector.parent().css('display', 'none');
                        }
                    }
                }
            });
        }

        let marker = null;
        if (data.marker) {
            marker = L.icon({
                iconUrl: data.marker,
                iconAnchor: [22, 94],
                popupAnchor: [-3, -76],
            });
        }

        if (data.points && data.points.length > 0) {
            data.points.forEach(function (point) {
                const content_show = point.point_content_show === 'yes';
                const content = point.point_content;

                const map_marker = new L.marker([point.point_lat, point.point_lng], { icon: marker }).addTo(map);
                if (content_show && content) {
                    map_marker.bindPopup(content);
                }
            });
        }
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_neshanmap.default', function($scope, $) {
        let wrap = $scope.find('.neshan-map-1'),
            data = wrap.data('json');

        handleNeshanMapElement(data);
    });
});