jQuery(document).ready(function ($){
    const ahuraUpdateCounterOnMiniCarts2 = function(){
        let wrap = $('.mini-cart2-element'),
            content = wrap.find('.mc2-content'),
            counter = wrap.find('.mc2-count'),
            count = content.data('count') || 0;

        if(count <= 0){
            counter.css('opacity', 0);
        } else {
            counter.css('opacity', 1);
        }
        counter.text(count);
    }

    $(document).on('click', '.add_to_cart_button.ajax_add_to_cart, button[name="update_cart"]', function (e){
        let selector = $(this),
            product_id = selector.data('product_id') || 0,
            cart_wrap = $('.mini-cart2-element'),
            counter = cart_wrap.find('.mc2-count'),
            cart_content = cart_wrap.find('.mc2-container'),
            count = 0;

        let add_interval = setInterval(() => {
            if (($(selector).hasClass && $(selector).hasClass('added')) || ($(selector).attr && $(selector).attr('name') === 'update_cart')) {
                $.ajax({
                    url: mc2_data.ajax_url,
                    data: {
                        action: 'ahura_update_mini_cart2_element',
                        product_id: product_id
                    },
                    type: 'POST',
                    complete: function(res){
                        if(res){
                            if(res.responseText !== '' || res.responseText !== null){
                                cart_content.html(res.responseText);
                                ahuraUpdateCounterOnMiniCarts2();
                            } else {
                                location.reload();
                            }
                        } else {
                            location.reload();
                        }
                    }
                });
                clearInterval(add_interval);
            }
        }, 850);
    });

    $(document).on('click', '.mini-cart2-element .cart-item-action-btn .remove', function (e){

        e.preventDefault();

        let selector = $(this),
            product_id = selector.data('product_id') || 0,
            item_key = selector.data('item_key') || 0,
            cart_wrap = $('.mini-cart2-element'),
            counter = cart_wrap.find('.mc2-count'),
            cart_content = cart_wrap.find('.mc2-container:visible'),
            count = 0;

        $('td.product-remove [data-product_id="' + product_id + '"]').click();

        $.ajax({
            url: mc2_data.ajax_url,
            data: {
                action: 'ahura_update_mini_cart2_element',
                'product_id': product_id,
                'item_key': item_key,
                'delete_product': true
            },
            type: 'POST',
            beforeSend: function (){
                selector.css({
                    'opacity': 0.5,
                    'filter': 'grayscale(1)',
                    'pointer-events': 'none'
                });
            },
            complete: function(res){
                selector.css({
                    'opacity': 1,
                    'filter': 'grayscale(0)',
                    'pointer-events': 'all'
                });
                if(res){
                    if(res.responseText !== '' || res.responseText !== null){
                        cart_content.html(res.responseText);
                        ahuraUpdateCounterOnMiniCarts2();
                    } else {
                        location.reload();
                    }
                } else {
                    location.reload();
                }
            },
            error: function (){
                selector.css({
                    'opacity': 1,
                    'filter': 'grayscale(0)',
                    'pointer-events': 'all'
                });
            }
        });
    });

    $(document).on('click', '.woocommerce-cart-form__cart-item .product-remove a', function (e){
        e.preventDefault();
        let initialSelectorProductId = $(this).data('product_id');
        let selector = '';
    
        let cartSelector = $(window).width() <= 1024 ? '.mini-cart2-element' : '.mini-cart2-element:visible';
    
        $(cartSelector + ' .mc2-main a.remove').each(function() {
            if ($(this).data('product_id') == initialSelectorProductId) {
                selector = $(this);
            }
        });
    
        if ($(cartSelector + ' .mc2-main a.remove').data('product_id') === initialSelectorProductId) {
            selector = $(cartSelector + ' .mc2-main a.remove');
        }
    
        let product_id = selector.data('product_id') || 0,
            item_key = selector.data('item_key') || 0,
            cart_wrap = $(cartSelector),
            counter = cart_wrap.find('.mc2-count'),
            cart_content = cart_wrap.find('.mc2-container'),
            count = 0;
    
        $.ajax({
            url: mc2_data.ajax_url,
            data: {
                action: 'ahura_update_mini_cart2_element',
                'product_id': product_id,
                'item_key': item_key,
                'delete_product': true
            },
            type: 'POST',
            beforeSend: function (){
                selector.css({
                    'opacity': 0.5,
                    'filter': 'grayscale(1)',
                    'pointer-events': 'none'
                });
            },
            complete: function(res){
                selector.css({
                    'opacity': 1,
                    'filter': 'grayscale(0)',
                    'pointer-events': 'all'
                });
                if(res){
                    if(res.responseText !== '' || res.responseText !== null){
                        cart_content.html(res.responseText);
                        ahuraUpdateCounterOnMiniCarts2();
                    } else {
                        location.reload();
                    }
                } else {
                    location.reload();
                }
            },
            error: function (){
                selector.css({
                    'opacity': 1,
                    'filter': 'grayscale(0)',
                    'pointer-events': 'all'
                });
            }
        });
    });    

    $(document).on('mouseover', '.mini-cart2-element', function (){
        let btn = $(this),
            box = btn.parent().find('.mc2-container');

        if(window.innerWidth <= 1024){
            return false;
        }

        box.fadeIn();
    });

    $(document).on('mouseleave', '.mini-cart2-element', function (){
        let btn = $(this),
            box = btn.parent().find('.mc2-container');

        box.fadeOut();
    });
});