jQuery(document).ready(function ($){
    let mm2_element = $(document).find('.mega-menu2-element');

    if(mm2_element.length > 0){
        let mm2_items = $('.mm2-items > div > ul > li'),
            mm2_wrapper = $('.mm2-wrapper'),
            mm2_overlay = $('.mm2-overlay'),
            mm2_sub_items = $('.mm2-sub-items');

        if(mm2_items.length > 0){
            mm2_items.mouseover(function(event) {
                mm2_items.removeClass('active-menu-item');
                $(this).addClass('active-menu-item');

                let ul = $(this).children('ul');
                mm2_sub_items.empty().css('backgroundImage', '');

                if (ul.length > 0) {
                    let clonedUl = ul.clone(true);
                    clonedUl.css('display', 'block');
                    mm2_sub_items.css('backgroundImage', clonedUl.css('backgroundImage') !== 'none' ? clonedUl.css('backgroundImage') : 'none');
                    mm2_sub_items.append(clonedUl);
                }
            });
        }

        if (mm2_items.length > 0) {
            mm2_items.first().addClass('active-menu-item').trigger('mouseover');
        }

        if(mm2_wrapper.length > 0){
            mm2_wrapper.mouseover(function(e) {
                let mm2_container = $(this).find('.mm2-container');
                mm2_container.addClass('mm2-show').css('display', '');

                let containerRect = mm2_container[0].getBoundingClientRect();

                if(mm2_overlay.length > 0){
                    mm2_overlay.css('top', containerRect.top + 'px').css('display', 'block');
                }
            });

            mm2_wrapper.mouseleave(function(e) {
                let mm2_container = $(this).find('.mm2-container');
                mm2_container.removeClass('mm2-show');

                if(mm2_overlay.length > 0){
                    mm2_overlay.css('display', 'none');
                }
            });
        }

        /**
         * Mobile menu
         */
		
		let mm2_side_toggle_callback = function(element) {
            let mm2_side_container = element;
            mm2_side_container.css('opacity', '');
            if(mm2_side_container.hasClass('mm2-side-show')){
                mm2_side_container.removeClass('mm2-side-show');
            } else {
                mm2_side_container.removeClass('mm2-side-show');
                mm2_side_container.addClass('mm2-side-show');
            }
        }

        $(document).on('click', '.mm2-side-button', function(e){
            e.preventDefault();
            let btn = $(this),
                mm2_side_container = btn.parent().find('.mm2-side-container');
            mm2_side_toggle_callback(mm2_side_container);
        });

        $(document).on('click', '.mm2-side-overlay, .mm2-close-btn', function(e){
            e.preventDefault();
            let mm2_side_container = $('.mm2-side-container');
            mm2_side_toggle_callback(mm2_side_container);
        });

        $(document).on('click', '.mm2-side-container li > span', function(e){
            e.preventDefault();
            $(this).parent().toggleClass('is-toggled');
        });
    }
});