let handleMapbox1Element = function(data){
    if (typeof mapboxgl !== "undefined") {
        mapboxgl.accessToken = data.api_key;
        const map = new mapboxgl.Map({
            container: 'map_' + data.wid,
            style: data.style_key,
            center: [data.lng, data.lat],
            zoom: data.zoom,
            projection: 'globe'
        });

        map.on('style.load', () => {
            map.setFog({});
        });

        if (data.is_admin) {
            map.on("click", function (e) {
                if (typeof e.lngLat !== undefined) {
                    let lnglat = e.lngLat,
                        lng = lnglat.lng,
                        lat = lnglat.lat,
                        selector = jQuery('.mapbox-1-' + data.wid + ' .map-details .lnglat');

                    if (selector.length) {
                        if (lng && lat) {
                            selector.parent().css('display', 'block');
                            selector.text(`Longitude: ${lng} / Latitude: ${lat}`);
                        } else {
                            selector.parent().css('display', 'none');
                        }
                    }
                }
            });
        }

        if (data.points && data.points.length > 0) {
            data.points.forEach(function (point) {
                const content_show = point.point_content_show === 'yes';
                const content = point.point_content;

                let markerElement = null;
                if (data.marker) {
                    markerElement = document.createElement('div');
                    markerElement.className = 'marker marker-' + data.wid;
                    markerElement.style.backgroundImage = "url(" + data.marker.url + ")";
                }

                const marker = new mapboxgl.Marker(markerElement).setLngLat([point.point_lng, point.point_lat]);

                if (content_show && content) {
                    marker.setPopup(
                        new mapboxgl.Popup({ offset: 25 }).setHTML(content)
                    );
                }

                marker.addTo(map);
            });
        }
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_mapbox1.default', function($scope, $) {
        let wrap = $scope.find('.mapbox-1'),
            data = wrap.data('json');

        handleMapbox1Element(data);
    });
});