const handleItemsCarousel2Element = function (params) {
    let options = {
        loop: true,
        breakpoints: {
            640: {
                slidesPerView: params.mobilePerView,
                spaceBetween: params.spaceBetweenMobile || 10,
            },
            768: {
                slidesPerView: params.tabletPerView,
                spaceBetween: params.spaceBetweenTablet || 15,
            },
            1024: {
                slidesPerView: params.desktopPerView,
                spaceBetween: params.spaceBetween || 20,
            },
        },
    };

    if (params.autoPlayStatus === true) {
        options.autoplay = {
            delay: params.playDelay,
            disableOnInteraction: false,
        };
    }


    if (params.arrows) {
        options.navigation = {
            nextEl: `.items-carousel2-${params.widgetID} .swiper-button-next`,
            prevEl: `.items-carousel2-${params.widgetID} .swiper-button-prev`,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_items_carousel2.default', function($scope, $) {
        let wrap = $scope.find('.items-carousel2'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleItemsCarousel2Element(sliderData);
    });
});