const handleItemsCarouselElement = function (params) {
  let options = {
    loop: true,
    breakpoints: {
      640: {
        slidesPerView: params.mobilePerView,
        spaceBetween: params.spaceBetweenMobile || 10,
      },
      768: {
        slidesPerView: params.tabletPerView,
        spaceBetween: params.spaceBetweenTablet || 15,
      },
      1024: {
        slidesPerView: params.desktopPerView,
        spaceBetween: params.spaceBetween || 20,
      },
    },
  };

  if (params.autoPlayStatus === true) {
    options.autoplay = {
      delay: params.playDelay,
      disableOnInteraction: false,
    };
  }
  
  if (params.pagination) {
    options.pagination = {
        el: `.items-carousel-${params.widgetID} .swiper-pagination`,
        clickable: true,
    };
  }

  if (params.arrows) {
    options.navigation = {
      nextEl: '.items-carousel-button-next',
      prevEl: '.items-carousel-button-prev',
    };
  }

  if(params.observer === true){
    options.observer = true;
    options.observeParents = true;
  }

  new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
  elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_items_carousel.default', function($scope, $) {
    let slider = $scope.find('.items-carousel'),
        sliderData = slider.data('slider');

    sliderData.container = slider;

    handleItemsCarouselElement(sliderData);
  });
});