jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/image_slider6.default', function($scope, $) {
        let wrap = $scope.find('.image-slider-6'),
            slider = wrap.find('.image-slider-slides'),
            thumbSlider = wrap.find('.image-slider-thumbs'),
            sliderData = slider.data('slider');

        let sliderOptions = {
            effect: "fade",
            loop: sliderData.loop || false,
        };

        if (sliderData.autoPlay === true){
            sliderOptions.autoplay = {
                delay: sliderData.transitionDuration || 4500,
                disableOnInteraction: false,
            };
        }

        if(sliderData.observer === true){
            sliderOptions.observer = true;
            sliderOptions.observeParents = true;
        }

        let thumbsSwiper = new Swiper(thumbSlider, {
            spaceBetween: 10,
            slidesPerView: 3,
        });

        sliderOptions.thumbs = {
            swiper: thumbsSwiper
        }

        let swiper = new Swiper(slider, sliderOptions);
    });
});