const handleImageSliderElement = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: params.mobilePerView,
            spaceBetween: 20,
            breakpoints: {
                640: {
                    slidesPerView: params.mobilePerView,
                    spaceBetween: 10,
                },
                768: {
                    slidesPerView: params.tabletPerView,
                    spaceBetween: 20,
                },
                1024: {
                    slidesPerView: params.slidesPerView,
                    spaceBetween: 20,
                },
            },
        };

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            };
        }

        if(params.pagination){
            options.pagination = {
                el: `.image-slider-1-${params.widgetID} .swiper-pagination`,
                clickable: true,
            };
        }

        if(params.navigation){
            options.navigation = {
                nextEl: `.image-slider-1-${params.widgetID} .swiper-btn-next`,
                prevEl: `.image-slider-1-${params.widgetID} .swiper-btn-prev`,
            };
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let img_swiper = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/image_slider.default', function($scope, $) {
        let wrap = $scope.find('.image-slider-1'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleImageSliderElement(sliderData);
    });
});