jQuery(document).ready(function($){
    let body = $('body');

    body.on('change', '.grid-products-5 .products-filter select', function(e){
        e.preventDefault();
        let select = $(this),
            wrap = select.parent().parent().parent().parent(),
            contentWrap = wrap.find('.products-list'),
            selectVal = select.val(),
            selectedOrder = select.find('option:selected').data('order');

        $.ajax({
            url: gpr5.ajax_url,
            data: {
                action: 'ahura_element_grid_products5',
                ordertype: selectedOrder,
                settings: select.data('settings')
            },
            type: 'POST',
            beforeSend: function () {
                wrap.addClass('has-loader');
            },
            complete: function (res) {
                res = res.responseText;
                wrap.removeClass('has-loader');
                if (res.length){
                    select.data('before-val', selectVal);
                    contentWrap.empty();
                    contentWrap.html(res);
                }
            },
            error: function () {
                wrap.removeClass('has-loader');
            }
        });
    });
});